package com.yeejoin.amos.supervision.business.feign;


import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportDangerDto;
import com.yeejoin.amos.supervision.core.common.dto.DangerDto;

/**
 * @author DELL
 */
@FeignClient(value = "AMOS-LATENT-DANGER", path = "latentDanger/api/latent/danger", configuration =
        {FeignConfiguration.class,FeignClientErrorDecoder.class})
public interface DangerFeignClient {

    /**
     * 隐患详情
     *
     * @param dangerId 隐患主键
     * @return FeignClientResult
     */
    @GetMapping(value = "/detail")
    FeignClientResult<DangerDto> getOne(@RequestParam Long dangerId);


    /**
     * 隐患的创建或者更新
     *
     * @param latentDangerDtoList 隐患对象数组
     * @return FeignClientResult
     */
    @PostMapping(value = "/patrol/save")
    FeignClientResult<List<DangerDto>> saveOrUpdateBatch(@RequestBody List<DangerDto> latentDangerDtoList, @RequestParam String flag);

    /**
     * 隐患分页查询
     * @param param 过滤条件
     * @return FeignClientResult
     */
    @GetMapping(value = "/page/list")
    FeignClientResult<Page<DangerDto>> pageList(@RequestBody Map param);


    /**
     * 查询所有的隐患
     * @param param 过滤条件
     * @return FeignClientResult
     */
    @GetMapping(value = "/list/all")
    FeignClientResult<List<DangerDto>> listAll(@RequestBody Map param);

    /**
     * 隐患等级
     *
     * @return List<Object>
     */
    @GetMapping(value = "/dangerLevel")
    FeignClientResult<Collection<DictionarieValueModel>> getDangerLevelData();

    /**
     * 治理方式
     *
     * @return List<Object>
     */
    @GetMapping(value = "/dangerGovernance")
    FeignClientResult<Collection<DictionarieValueModel>> getDangerGovernanceData();

    /**
     * 批量删除
     * @param ids 隐患ids
     * @return Boolean
     */
    @DeleteMapping("/delete")
    FeignClientResult<Boolean> deleteDangerBatch(@RequestParam String ids);

    /**
     * 根据参数获取隐患复查信息
     *
     * @param orgCode
     * @param t1
     * @param t2
     * @return
     */
    @GetMapping(value = "/supervision/reviewInfo")
    FeignClientResult<Map<String, List<CheckReportDangerDto>>> getReviewInfoList(@RequestParam String orgCode,
                                                                                 @RequestParam String t1,
                                                                                 @RequestParam String t2);
    
    
    @GetMapping(value = "/web/updateStatusByUserIdAndPlandIdLike/{userId}/{plandId}")
    public ResponseModel<Object> updateStatusByUserIdAndPlandIdLike(@PathVariable String userId,@PathVariable String plandId) ;
}
