package com.yeejoin.precontrol.common.vo;

import java.io.Serializable;
import java.util.List;

import com.yeejoin.precontrol.common.annotations.TableFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 风险管控预选人员表Vo
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
public class TaskRiskControlPrePersonVo implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	private Long taskId;

	@ApiModelProperty(value = "人员id")
	private Long personId;

	@ApiModelProperty(value = "人员id")
	private String personName;

	@ApiModelProperty(value = "人员类型")
	private Long type;

	@ApiModelProperty(value = "注册考试状态")
	private Integer examStatus;

	@ApiModelProperty(value = "注册知识状态")
	private Integer knowledgeStatus;
	
	@ApiModelProperty(value = "工种")
	private String postName;
	
	@ApiModelProperty(value = "资质")
	private List<String> certificate;
	
	@ApiModelProperty(value = "考试推送")
	private Integer taskExamStatus;
	
	@ApiModelProperty(value = "知识推送")
	private Integer taskKnowledgeStatus;
	
	@ApiModelProperty(value = "是否已经使用")
	private boolean used;
	
	private String companyName;
	
	private String roleName;
	
	private String headPhoto;
}
