package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.tzs.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.tzs.api.service.IEquipmentCategoryService;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.EquipmentCategoryServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 装备分类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@RestController
@Api(tags = "装备分类Api")
@RequestMapping(value = "/equipment-category")
public class EquipmentCategoryController extends BaseController {

	@Autowired
	EquipmentCategoryServiceImpl equipmentCategoryServiceImpl;

	@Autowired
	IEquipmentCategoryService equipmentCategoryService;

	/**
	 * 新增装备分类
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增装备分类", notes = "新增装备分类")
	public ResponseModel<EquipmentCategoryDto> save(@RequestBody EquipmentCategoryDto model) {
		model = equipmentCategoryServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除装备分类", notes = "根据sequenceNbr删除装备分类")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个装备分类", notes = "根据sequenceNbr查询单个装备分类")
	public ResponseModel<EquipmentCategoryDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "装备分类分页查询", notes = "装备分类分页查询")
	public ResponseModel<Page<EquipmentCategoryDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) {
		Page<EquipmentCategoryDto> page = new Page<EquipmentCategoryDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryForEquipmentCategoryPage(page));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "装备分类列表全部数据查询", notes = "装备分类列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<EquipmentCategoryDto>> selectForList() {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryForEquipmentCategoryList());
	}

	/**
	 * 树
	 *
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "装备分类列表全部数据查询", notes = "装备分类列表全部数据查询")
	@GetMapping(value = "/tree")
	public ResponseModel<Object> tree(@RequestParam Long code) throws Exception {
		EquipmentCategory root = equipmentCategoryServiceImpl.getOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getCode, code.toString()));
		QueryWrapper<EquipmentCategory> queryWrapper = new QueryWrapper<>();
		queryWrapper.likeRight("code", code.toString().replaceAll("0+$", ""));
		Collection<EquipmentCategory> list = equipmentCategoryServiceImpl.list(queryWrapper);
		Menu menu = new Menu(root.getId(), root.getName(), 0L, 0);
		List<Menu> menus = TreeParser.getTree(root.getId(), list, EquipmentCategory.class.getName(), "getId", 0, "getName",
				"getParentId", null, "getCode");
		menu.setChildren(menus);
		List<Menu> tree = new ArrayList<>();
		tree.add(menu);
		return ResponseHelper.buildResponse(tree);
	}
	/**
	 * 设备分类八大类
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "设备分类八大类", notes = "设备分类八大类")
	@GetMapping(value = "/selectClassify")
	public ResponseModel<JSONArray> selectClassify() {
		List<EquipmentCategoryDto> equipmentCategoryDtos = equipmentCategoryServiceImpl.selectClassify();
		JSONArray jsonArray = new JSONArray();
		equipmentCategoryDtos.forEach(e->{
					jsonArray.add(e.getName());
				}
		);
		return ResponseHelper.buildResponse(jsonArray);
	}

    /**
     * 设备八大类列表树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "设备八大类列表树", notes = "设备八大类列表树")
    @GetMapping(value = "/equipTree")
    public ResponseModel<Object> equipTree(@RequestParam(value = "type",required = false) String type) {
        return ResponseHelper.buildResponse( equipmentCategoryService.equipTree(type));
    }

	/**
	 * 设备认领总览
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "设备认领总览", notes = "设备认领总览")
	@GetMapping(value = "/equipClaimOverview")
	public ResponseModel<Object> equipClaimOverview() {
		return ResponseHelper.buildResponse(equipmentCategoryService.equipClaimOverview());
	}

	/**
	 * 生成监管码和96333码
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/createSupervisorCode")
	@ApiOperation(httpMethod = "POST", value = "生成监管码和96333码", notes = "生成监管码和96333码")
	public ResponseModel<Object> createSupervisorCode(@RequestBody Map<String,Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryService.createSupervisorCode(map));
	}


	/**
	 * 生成管辖分局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/creatTree")
	@ApiOperation(httpMethod = "GET", value = "生成管辖分局树", notes = "生成管辖分局树")
	public ResponseModel<Object> creatTree() {
		return ResponseHelper.buildResponse(equipmentCategoryService.creatTree());
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getTable")
	@ApiOperation(httpMethod = "GET", value = "设备认领和设备管理通用接口", notes = "设备认领和设备管理通用接口")
	public ResponseModel<Page<Map<String,Object>>> getTable(@RequestParam Map<String,Object> map) {
		return equipmentCategoryServiceImpl.getTable(map);
	}

}
