package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProcessTypeEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.WhetherItPassEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.OverProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectInitiation;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectInitiationService;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectInitiationServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;

/**
 * 小您过目结项流程相关API
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "项目结项流程Api")
@RequestMapping(value = "/projectOver")
public class ProjectOverFlowController extends BaseController {

    @Resource
    private ProjectServiceImpl projectServiceImpl;

    @Resource
    private IProjectInitiationService iProjectInitiationService;

    @Resource
    private ProjectInitiationServiceImpl projectInitiationServiceImpl;

    /**
     * 项目结项流程启动API
     *
     * @param dto 项目结项信息
     */
    @PostMapping(value = "/flowStart")
    @ApiOperation(value = "项目竣工结项（竣工结项确认）- 结项项目结项流程启动API", notes = "项目竣工结项（竣工结项确认）- 项目结项流程启动API")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public ResponseModel<Object> overProjectFlowStart(@RequestBody OverProjectDto dto) {
        String token = RequestContext.getToken();
        String appKey = RequestContext.getAppKey();
        String product = RequestContext.getProduct();
        //分支线程执行流程
        Thread t1 = new Thread(() -> {
            RequestContext.setToken(token);
            RequestContext.setAppKey(appKey);
            RequestContext.setProduct(product);
            iProjectInitiationService.overProjectFlowStart(dto);
        });
        t1.start();
        return ResponseHelper.buildResponse(dto);
    }

    /**
     * 项目结项执行流程
     *
     * @param dto 项目结项信息
     */
    @PostMapping(value = "/flowExecute")
    @ApiOperation(value = "项目结项流程执行通用API", notes = "项目结项流程执行通用API")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public ResponseModel<Object> overProjectFlowExecute(@RequestBody OverProjectDto dto) {
        iProjectInitiationService.overProjectFlowExecute(dto);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(value = "根据项目表sequenceNbr查询结项流程相关信息", notes = "根据项目表sequenceNbr查询结项流程相关信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public ResponseModel<OverProjectDto> selectOne(@PathVariable Long sequenceNbr) {
        Project project = projectServiceImpl.getById(sequenceNbr);
        LambdaQueryWrapper<ProjectInitiation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectInitiation::getInstanceId, project.getInstanceId());
        wrapper.eq(ProjectInitiation::getType, ProcessTypeEnum.项目结项.getType());
        wrapper.orderByDesc(ProjectInitiation::getRecDate);
        wrapper.last(" limit 1");
        ProjectInitiation one = projectInitiationServiceImpl.getOne(wrapper);
        if (ObjectUtils.isNotEmpty(one) && StringUtils.isNotEmpty(one.getContext())) {
            OverProjectDto overProjectDto = JSON.parseObject(one.getContext(), OverProjectDto.class);
            if ((StringUtils.isNotEmpty(overProjectDto.getAuditOpinion()) && WhetherItPassEnum.REJECT.getCode().equals(overProjectDto.getCondition())) ||
                    (StringUtils.isNotEmpty(overProjectDto.getIsAgree()) && WhetherItPassEnum.REJECT.getCode().equals(overProjectDto.getIsAgree()))) {
                return ResponseHelper.buildResponse(new OverProjectDto());
            }
            return ResponseHelper.buildResponse(overProjectDto);
        }
        return ResponseHelper.buildResponse(new OverProjectDto());
    }
}
