package com.yeejoin.amos.supervision.core.common.dto;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author xixinzhao
 */
@Data
public class DangerDto {

    /**
     * 隐患id
     */
    private Long id;

    /**
     * 隐患名称
     */
    private String name;

    /**
     * 检查项记录id
     */
    private Long bizId;

    /**
     * 隐患级别
     */
    private String dangerLevel;

    /**
     * 状态
     */
    private String state;

    /**
     * 是否删除
     * 0：未删除 1：已删除
     */
    private Boolean deleted;

    /**
     * 治理方式
     */
    private String governWay;

    /**
     * 业务类型（不同业务创建的隐患以此区分:巡检隐患、防火监督隐患、其他隐患。。。）
     */
    private String bizType;

    /**
     * 整改期限
     */
    private Date reformLimitDate;


    /**
     * 检查类型:1-自行检查 ；2计划检查
     */
    private String checkMode;


    /**
     * 隐患图片列表
     */
    private List<String> photoUrl;

    /**
     * 检查项名称
     */
    private String inputItemName;

    /**
     * 检查时间
     */
    private String checkTime;

    /**
     * 2470	49	2052
     * 检查人员名称
     */
    private String checkUserName;

    /**
     * 责任单位
     */
    private String pointName;

    /**
     * 状态
     */
    private String stateName;
}
