package com.yeejoin.amos.supervision.business.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.supervision.business.dto.HiddenDangerExportDto;
import com.yeejoin.amos.supervision.business.dto.HiddenDangerImportDto;
import com.yeejoin.amos.supervision.business.service.intfc.IHiddenDangerService;
import com.yeejoin.amos.supervision.business.util.FileHelper;
import com.yeejoin.amos.supervision.core.common.dto.DangerDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author DELL
 */
@Slf4j
@RestController
@Api(tags = "隐患api")
@RequestMapping(value = "api/hidden/danger")
public class HiddenDangerController extends AbstractBaseController {

    @Autowired
    IHiddenDangerService iHiddenDangerService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询", notes = "分页查询")
    @PostMapping(value = "/{planId}/page-list")
    public ResponseModel pageList(
            @PathVariable String planId,
            @RequestParam(value = "pointId", required = false) Long pointId,
            @RequestParam(value = "level", required = false) String level,
            @RequestParam(value = "status", required = false) String status,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        Page page = new Page<DangerDto>(current, size);
        IPage<DangerDto> dtoList = iHiddenDangerService.pageList(page, planId, pointId, level, status);
        return ResponseHelper.buildResponse(dtoList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询隐患详情", notes = "查询隐患详情")
    @GetMapping("/{latentDangerId}")
    public ResponseModel getOne(@PathVariable Long latentDangerId) {
        DangerDto dangerDto = iHiddenDangerService.getOne(latentDangerId);
        return ResponseHelper.buildResponse(dangerDto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新隐患", notes = "更新隐患")
    @PutMapping(value = "/{latentDangerId}")
    public ResponseModel updateDanger(
            @RequestBody DangerDto dangerDto,
            @PathVariable Long latentDangerId) {
        dangerDto = iHiddenDangerService.updateDanger(latentDangerId, dangerDto);
        return ResponseHelper.buildResponse(dangerDto);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导入隐患", notes = "导入隐患")
    @RequestMapping(value = "/import", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public ResponseModel importDanger(
            @RequestParam(value = "planId") Long planId,
            @RequestParam(value = "pointId") Long pointId,
            @ApiParam(value = "导入数据文件", required = true) @RequestBody MultipartFile file) {
        String fileName = file.getOriginalFilename();
        assert fileName != null;
        if (!fileName.endsWith(".xls")) {
            throw new RuntimeException("文件格式不正确");
        }
        List<HiddenDangerImportDto> list = FileHelper.importExcel(file, 0, 1, HiddenDangerImportDto.class);
        iHiddenDangerService.importDanger(planId, pointId, list);
        return ResponseHelper.buildResponse("导入成功");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出指定计划的隐患", notes = "导出指定计划的隐患")
    @PostMapping(value = "{planId}/export")
    public void exportDangerList(
            @PathVariable String planId,
            @RequestParam(value = "pointId", required = false) Long pointId,
            @RequestParam(value = "level", required = false) String level,
            @RequestParam(value = "status", required = false) String status,
            HttpServletResponse response) {
        List<HiddenDangerExportDto> dtoList = iHiddenDangerService.listAll(planId, pointId, level, status);
        String fileName = "隐患问题清单" + System.currentTimeMillis();
        FileHelper.exportExcel(dtoList, "隐患问题清单", "隐患问题清单", HiddenDangerExportDto.class, fileName + ".xls", response);
    }
}
