package com.yeejoin.amos.supervision.business.feign;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.supervision.core.common.dto.DangerDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author DELL
 */
@FeignClient(value = "API-DANGER-API", path = "danger")
public interface DangerFeignClient {

    /**
     * 隐患详情
     *
     * @param sequenceNbr 隐患主键
     * @return FeignClientResult
     */
    @GetMapping(value = "/{sequenceNbr}/detail")
    FeignClientResult<DangerDto> getOne(@PathVariable Long sequenceNbr);


    /**
     * 隐患的创建或者更新
     *
     * @param danger 隐患对象数组
     * @return FeignClientResult
     */
    @PostMapping(value = "/saveOrUpdateBatch")
    FeignClientResult<List<DangerDto>> saveOrUpdateBatch(@RequestBody List<DangerDto> danger);

    /**
     * 隐患分页查询
     *
     * @param page   分页信息
     * @param ids    隐患ids
     * @param level  隐患级别
     * @param status 隐患状态
     * @return FeignClientResult
     */
    @GetMapping(value = "/page-list")
    FeignClientResult<IPage<DangerDto>> pageList(Page page, @RequestParam String ids, @RequestParam(required = false) String level, @RequestParam(required = false) String status);


    /**
     * 查询所有的隐患
     *
     * @param ids    隐患ids
     * @param level  隐患级别
     * @param status 隐患状态
     * @return FeignClientResult
     */
    @GetMapping(value = "/list-all")
    FeignClientResult<List<DangerDto>> listAll(@RequestParam String ids, @RequestParam(required = false) String level, @RequestParam(required = false) String status);
}
