package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 值班班次
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@ApiModel(value = "DutyCarDto", description = "值班车辆")
public class DutyCarExcelDto implements Serializable {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "序号", index = 0)
    @ApiModelProperty(value = "序号")
    private Integer number;

    @ExcelIgnore
    @ApiModelProperty(value = "消防队伍id")
    private String teamId;

    @ExcelProperty(value = "消防队伍", index = 1)
    @ApiModelProperty(value = "消防队伍名称")
    private String teamName;

    @ExcelIgnore
    @ApiModelProperty(value = "用户id")
    private String userId;

    @ExcelProperty(value = "姓名", index = 2)
    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ExcelIgnore
    @ApiModelProperty(value = "岗位id")
    private String postType;

    @ExcelProperty(value = "岗位", index = 3)
    @ApiModelProperty(value = "岗位名称")
    private String postTypeName;

    @ExcelIgnore
    @ApiModelProperty(value = "车辆id")
    private String carId;

    @ExplicitConstraint(indexNum = 4, sourceClass = CommonExplicitConstraint.class, method = "getCarList") //固定下拉内容
    @ExcelProperty(value = "车辆名称（车牌）", index = 4)
    @ApiModelProperty(value = "车辆名称")
    private String carName;
    // 需求 958 新增值班区域 值班区域id 字段 导出字段 by kongfm 2021-09-15
    @ExplicitConstraint(indexNum = 5, sourceClass = CommonExplicitConstraint.class, method = "getDutyArea") //固定下拉内容
    @ExcelProperty(value = "值班区域", index = 5)
    @ApiModelProperty(value = "值班区域")
    private String dutyArea;
    }
