package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_regional_companies",autoResultMap = true)
public class RegionalCompanies extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 所属区域公司id
     */
	@TableField("regional_companies_seq")
    private Long regionalCompaniesSeq;

    /**
     * 所属区域公司名称
     */
	@TableField("regional_companies_name")
    private String regionalCompaniesName;

    /**
     * 所属区域公司code
     */
	@TableField("regional_companies_code")
    private String regionalCompaniesCode;

    /**
     *  经销商平台单位id
     */
	@TableField("unit_id")
    private Long unitId;
    /**
     *  经销商业务单位id
     */
    @TableField("unit_info_id")
    private Long unitInfoId;


    @TableField("development_area")
    private String developmentArea;	//开发区域
    @TableField("consignee")
    private String consignee;	//收货人
    @TableField("phone")
    private String phone;	//收货人电话
    @TableField("consignee_region")
    private String consigneeRegion;	//收货区域
    @TableField(value = "consignee_region_code",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> consigneeRegionCode;	//收货区域code
    @TableField("address")
    private String address;	//收货详细地址

    @TableField(exist = false)
    private String regionalAddress;//区域公司归属地

    @TableField(exist = false)
    private String companyCode;
    @TableField(exist = false)
    private List<Object> children;









    public RegionalCompanies(Long regionalCompaniesSeq, String regionalCompaniesName, String regionalCompaniesCode, Long unitId,Long unitInfoId) {
        this.regionalCompaniesSeq = regionalCompaniesSeq;
        this.regionalCompaniesName = regionalCompaniesName;
        this.regionalCompaniesCode = regionalCompaniesCode;
        this.unitId = unitId;
        this.unitInfoId = unitInfoId;
    }

    public RegionalCompanies() {
    }
}
