package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.feign.IdxFeign;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizTableMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizTableService;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IPermissionService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
public class IdxBizTableServiceImpl implements IIdxBizTableService {

    @Autowired
    private IPermissionService permissionService;

    @Autowired
    private IdxBizTableMapper idxBizTableMapper;

    @Autowired
    private IdxFeign idxFeign;

    /**
     * 分页查询业务事实表的数据-IDX(/idx/table/getPage)前置接口, 增加权限控制
     *
     * @param map 查询参数
     */
    public Page<Map<String, Object>> getPage(Map<String, Object> map) {
        List<String> currentUserPermissions = permissionService.getCurrentUserPermissions();
        if (Objects.isNull(currentUserPermissions)) {
            currentUserPermissions = new ArrayList<>();
        }
        String gatewayIds = String.join(",", currentUserPermissions);
        if (!gatewayIds.isEmpty()) {
            map.put("GATEWAY_ID", String.format("[%s]", gatewayIds));
        }
        FeignClientResult<Page<Map<String, Object>>> page = idxFeign.getPage(map);
        return page.getResult();
    }

    /**
     * 获取下拉列表参数
     *
     * @param tableName       表名
     * @param column          列名
     * @param valueColumn     数据值列
     * @param conditionColumn 条件列名
     * @param conditionValue  条件值
     * @param isFx            是否是"分析变量"
     */
    @Override
    public List<Map<String, Object>> getSelectOptions(String tableName, String column, String valueColumn, String conditionColumn, String conditionValue, String isFx) {
        List<String> permissions = permissionService.getCurrentUserPermissions();
        if (Objects.isNull(permissions)) {
            permissions = new ArrayList<>();
        }
        return idxBizTableMapper.getSelectOptions(tableName, column, valueColumn, conditionColumn, conditionValue, isFx, permissions);
    }
}
