package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: GeographicalRegion
 * @Author: Jianqiang Gao
 * @Description: 消防车辆参数信息
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("ast_firevehicleinfo")
@ApiModel(value = "FireVehicleInfo对象", description = "消防车辆参数信息")
public class FireVehicleInfo implements Serializable {

    private static final long serialVersionUID = 8914795353036093330L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "消防车辆id")
    @TableField("fireVehicleid")
    private String fireVehicleId;

    @ApiModelProperty(value = "字段名（英文）")
    @TableField("fieldname")
    private String fieldName;

    @ApiModelProperty(value = "中文名")
    @TableField("fieldlabel")
    private String fieldLabel;

    @ApiModelProperty(value = "属性值")
    @TableField("value")
    private String value;

    @ApiModelProperty(value = "数据类型")
    @TableField("datatype")
    private String dataType;

    @ApiModelProperty(value = "计量单位")
    @TableField("measureunit")
    private String measureUnit;

    @ApiModelProperty(value = "是否必填")
    @TableField(value = "ismust",typeHandler = BitTypeHandler.class)
    private Boolean isMust;

    @ApiModelProperty(value = "排序")
    @TableField("sort")
    private Integer sort;

    @ApiModelProperty(value = "创建时间")
    @TableField("createdate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间")
    @TableField("updatedate")
    private Date updateDate;

    @ApiModelProperty(value = "主资源标识")
    @TableField("mrid")
    private String mrid;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "别名")
    @TableField("aliasname")
    private String aliasname;

    @ApiModelProperty(value = "描述")
    @TableField("description")
    private String description;

}