package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: GeographicalRegion
 * @Author: Jianqiang Gao
 * @Description: 建筑
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("floor")
@ApiModel(value = "Floor对象", description = "建筑数据")
public class Floor implements Serializable {

    private static final long serialVersionUID = 2349152717288079913L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "CIM的ID")
    @TableField("mrid")
    private String mRid;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "空间位置信息")
    @TableField("coordinates")
    private String coordinates;

    @ApiModelProperty(value = "高度")
    @TableField("height")
    private BigDecimal height;

    @ApiModelProperty(value = "宽度")
    @TableField("width")
    private BigDecimal width;

    @ApiModelProperty(value = "楼层号")
    @TableField("no")
    private Integer no;

    @ApiModelProperty(value = "对角坐标标识")
    @TableField(value = "rect",typeHandler = BitTypeHandler.class)
    private Boolean rect;

    @ApiModelProperty(value = "安全出口位置图")
    @TableField("exitplan")
    private String exitPlan;

    @ApiModelProperty(value = "疏散走道布置图")
    @TableField("evacuationwalk")
    private String evacuationWalk;

    @ApiModelProperty(value = "中文描述")
    @TableField("description")
    private String description;

    @ApiModelProperty(value = "建（构）筑物标识")
    @TableField("buildingid")
    private String buildingId;

}