package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * co_access_recording
 * @author 
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode
@TableName("co_access_recording")
@ApiModel(value="AccessRecording对象", description="")
public class AccessRecording extends BaseEntity {

    /**
     * 持卡人头像
     */
    private String cardholderAvatar;

    /**
     * 持卡人姓名
     */
    private String cardholderName;

    /**
     * 持卡人性别
     */
    private String cardholderGender;

    /**
     * 卡号
     */
    private String cardCode;

    /**
     * 门禁编号
     */
    private String accessNumber;

    /**
     * 所属部门
     */
    private String cardholderDepartment;

    /**
     * 门禁位置
     */
    private String accessPosition;

    /**
     * 角色
     */
    private String cardholderCharacter;

    /**
     * 开门时间
     */
    private String crossTime;

    /**
     * 进/出，0-进
     */
    @TableField(value = "in_or_out",typeHandler = BitTypeHandler.class)
    private Boolean inOrOut;

    /**
     * 状态
     */
    private Integer status;

    private static final long serialVersionUID = 1L;
}