package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author 子杨
 * @since 2021-10-14
 */
@Data
@TableName("wl_topography_line")
public class TopographyLine implements Serializable {


	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = -4606901869008673028L;
	
	/**
	 * 起点
	 */
	@TableField("line_from")
	private String lineFrom;
	/**
	 * 终点
	 */
	@TableField("line_to")
	private String lineTo;
	/**
	 * 树id
	 */
	@TableField("treeid")
	private String treeid;
	@TableField("id")
	private String id;
	@TableField("create_date")
	private Date createDate;
	@TableField("create_user")
	private String createUser;
	@TableField(value = "is_delete",typeHandler = BitTypeHandler.class)
	private Boolean isDelete;
	@TableField("update_date")
	private Date updateDate;
	@TableField("update_user")
	private String updateUser;
	/**
	 * 可点击
	 */
	@TableField(value = "clickable",typeHandler = BitTypeHandler.class)
	private Boolean clickable;
	/**
	 * 树节点id
	 */
	@TableField("tree_node_id")
	private String treeNodeId;
	/**
	 * 异常数量
	 */
	@TableField("number")
	private Integer number;
	/**
	 * 异常状态
	 */
	@TableField("state")
	private Integer state;
	/**
	 * 类型：1-网络拓扑图，2-PAMS
	 */
	@TableField("type")
	private Integer type;
	/**
	 * 有箭头
	 */
	@TableField(value = "has_arrow",typeHandler = BitTypeHandler.class)
	private Boolean hasArrow;
	/**
	 * 起点位置
	 */
	@TableField("from_port")
	private String fromPort;
	/**
	 * 终点位置
	 */
	@TableField("to_port")
	private String toPort;
	/**
	 * 是虚线
	 */
	@TableField(value = "is_dash",typeHandler = BitTypeHandler.class)
	private Boolean isDash;
	/**
	 * 颜色
	 */
	@TableField("line_color")
	private Integer lineColor;
	/**
	 * 部门单位
	 */
	@TableField("org_code")
	private String orgCode;
}

