package com.yeejoin.equipmanage.common.enums;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @title: EmergencyEquipTypeEnum
 */
@AllArgsConstructor
@Getter
public enum EmergencyEquipTypeEnum {

    MHQ("3104", "fireExtinguisher", "灭火器", "MHQ"),
    XHS("3105", "fireHydrant", "消火栓", "XHS"),
    ZYSKQHXQ("1106", "respirator", "正压式呼吸器", "ZYSKQHXQ"),
    XFC("3910", "fireShovel", "消防铲", "XFC"),
    XFF("3904", "fireAxe", "消防斧", "XFF"),
    XFT("3911", "fireBucket", "消防桶", "XFT");

    private String code;
    private String name;
    private String describe;
    private String key;

    public static String getCodeByName(String name) {
        for (EmergencyEquipTypeEnum e : EmergencyEquipTypeEnum.values()) {
            if (e.getName().equals(name)) {
                return e.code;
            }
        }
        return null;
    }

    public static String getCodeByKey(String key) {
        for (EmergencyEquipTypeEnum e : EmergencyEquipTypeEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.code;
            }
        }
        return null;
    }

    public static EmergencyEquipTypeEnum getEnumByName(String name) {
        for (EmergencyEquipTypeEnum e : EmergencyEquipTypeEnum.values()) {
            if (e.getName().equals(name)) {
                return e;
            }
        }
        return null;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String, String>> enumList = new ArrayList<>();
        for (EmergencyEquipTypeEnum c: EmergencyEquipTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", c.getCode());
            map.put("key", c.getName());
            map.put("name", c.getDescribe());
            enumList.add(map);
        }
        return enumList;
    }
}
