package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.RiskWorkHazadousWork;
import com.yeejoin.precontrol.common.service.IRiskWorkHazadousWorkService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * 风险作业关联危险作业表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@RestController
@Api(tags = "风险作业关联危险作业表Api")
@RequestMapping(value = "/risk-work-hazadous-work", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RiskWorkHazadousWorkController {

    @Autowired
    IRiskWorkHazadousWorkService iRiskWorkHazadousWorkService;


    /**
     * 新增风险作业关联危险作业表
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增风险作业关联危险作业表", notes = "新增风险作业关联危险作业表")
    public boolean saveRiskWorkHazadousWork(HttpServletRequest request, @RequestBody RiskWorkHazadousWork riskWorkHazadousWork) {
        return iRiskWorkHazadousWorkService.save(riskWorkHazadousWork);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iRiskWorkHazadousWorkService.removeById(id);
    }


    /**
     * 修改风险作业关联危险作业表
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改风险作业关联危险作业表", notes = "修改风险作业关联危险作业表")
    public boolean updateByIdRiskWorkHazadousWork(HttpServletRequest request, @RequestBody RiskWorkHazadousWork riskWorkHazadousWork) {
        return iRiskWorkHazadousWorkService.updateById(riskWorkHazadousWork);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public RiskWorkHazadousWork selectById(HttpServletRequest request, @PathVariable Long id) {
        return iRiskWorkHazadousWorkService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<RiskWorkHazadousWork> listPage(String pageNum, String pageSize,
                                                RiskWorkHazadousWork riskWorkHazadousWork) {

        Page<RiskWorkHazadousWork> pageBean;
        QueryWrapper<RiskWorkHazadousWork> riskWorkHazadousWorkQueryWrapper = new QueryWrapper<>();
        Class<? extends RiskWorkHazadousWork> aClass = riskWorkHazadousWork.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(riskWorkHazadousWork);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(riskWorkHazadousWork);
                        riskWorkHazadousWorkQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(riskWorkHazadousWork);
                        riskWorkHazadousWorkQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(riskWorkHazadousWork);
                        riskWorkHazadousWorkQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(riskWorkHazadousWork);
                        riskWorkHazadousWorkQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<RiskWorkHazadousWork> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iRiskWorkHazadousWorkService.page(pageBean, riskWorkHazadousWorkQueryWrapper);
        return page;
    }
}


