package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 起重机械
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_crane")
public class SpecialCrane extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备全省唯一编号
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 起重机械载荷（t）
	 */
	@TableField("crane_load")
	private String craneLoad;
	/**
	 * 提升力矩（Kg/s）
	 */
	@TableField("lifting_torque")
	private String liftingTorque;
	/**
	 * 最大提升高度（m）
	 */
	@TableField("max_lifting_height")
	private String maxLiftingHeight;
	/**
	 * 起升高度（主钩）(m)
	 */
	@TableField("main_lifting_height")
	private String mainLiftingHeight;
	/**
	 * 起升高度（副钩）(m)
	 */
	@TableField("sec_lifting_height")
	private String secLiftingHeight;
	/**
	 * 工作半径（m）
	 */
	@TableField("working_radius")
	private String workingRadius;
	/**
	 * 工作级别
	 */
	@TableField("work_level")
	private String workLevel;
	/**
	 * 轨距（m）
	 */
	@TableField("gauge")
	private String gauge;
	/**
	 * 幅度（m）
	 */
	@TableField("ranges")
	private String ranges;
	/**
	 * 起升速度（m/min）
	 */
	@TableField("lifting_speed")
	private String liftingSpeed;
	/**
	 * 起升速度(主钩)(m/min)
	 */
	@TableField("main_speed_height")
	private String mainSpeedHeight;
	/**
	 * 起升速度(副钩) （m/min）
	 */
	@TableField("sec_speed_height")
	private String secSpeedHeight;
	/**
	 * 变幅形式
	 */
	@TableField("luffing_form")
	private String luffingForm;
	/**
	 * 跨度（m）
	 */
	@TableField("span")
	private String span;
	/**
	 * 额定起重量(主钩) (t)
	 */
	@TableField("main_rated_lifting_capacity")
	private String mainRatedLiftingCapacity;
	/**
	 * 额定起重量(副钩)(t)
	 */
	@TableField("sec_rated_lifting_capacity")
	private String secRatedLiftingCapacity;
	/**
	 * 大车运行速度（m/min）
	 */
	@TableField("big_car_speed")
	private String bigCarSpeed;
	/**
	 * 小车运行速度（m/min）
	 */
	@TableField("small_car_speed")
	private String smallCarSpeed;

}
