package com.yeejoin.amos.boot.module.common.api.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 动态表单实例表
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "cb_dynamic_form_instance", autoResultMap = true)
public class DynamicFormInstance extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 字段名
     */
    @TableField("field_code")
    private String fieldCode;
    /**
     * 中文名
     */
    @TableField("field_name")
    private String fieldName;
    /**
     * 数据类型：文本，数字，枚举,日期
     */
    @TableField("field_type")
    private String fieldType;
    /**
     * 分组编号
     */
    @TableField("group_code")
    private String groupCode;
    /**
     * 字段分组id
     */
    @TableField("group_id")
    private Long groupId;
    /**
     * 动态配置字段的值
     */
    @TableField("field_value")
    private String fieldValue;
    /**
     * field_value的描述（冗余字段，在列表时查询时显示）
     */
    @TableField("field_value_label")
    private String fieldValueLabel;
    /**
     * 设备实例id
     */
    @TableField("instance_id")
    private Long instanceId;
    /**
     * 字段定义信息的主键
     */
    @TableField("form_column_id")
    private Long formColumnId;
    /**
     * 查询策略;全等,模糊,区间
     */
    @TableField("query_strategy")
    private String queryStrategy;
    /**
     * 应用标识（数据隔离使用）
     */
    @TableField("app_key")
    private String appKey;

    /**
     * 不能为空
     */
    @TableField("not_null")
    private Boolean notNull;

    /**
     * 是否一行显示(兼容已有动态表单使用)
     */
    @TableField("block")
    private Boolean block;

    @TableField(value = "column_Config", typeHandler = JacksonTypeHandler.class)
    private JSONObject columnConfig;

    /**
     * 排序字段
     */
    @TableField("sort")
    private int sort;

    /**
     * 组织机构
     */
    @TableField("org_code")
    private String orgCode;


    public DynamicFormInstance() {
        super();
    }

    public DynamicFormInstance(Long alertFormId, String fieldName, String fieldCode, boolean block) {
        this.instanceId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.block = block;
    }

    public DynamicFormInstance(Long alertFormId, String fieldName, String fieldCode, boolean block, String alertTypeCode) {
        this.instanceId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.block = block;
        this.fieldValueLabel = alertTypeCode;
    }

    public DynamicFormInstance(Long alertFormId, String fieldName, String fieldCode, boolean block, String groupCode,
                               String fieldValue, String fieldValueCode) {
        this.instanceId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.block = block;
        this.groupCode = groupCode;
        this.fieldValue = fieldValue;
        this.fieldValueLabel = fieldValueCode;
    }

    public DynamicFormInstance(Long alertFormId, String groupCode, String fieldName, String fieldCode,
                               String fieldValue, String fieldValueCode, Boolean block) {
        this.instanceId = alertFormId;
        this.groupCode = groupCode;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.fieldValue = fieldValue;
        this.fieldValueLabel = fieldValueCode;
        this.block = block;
    }
}
