package com.yeejoin.amos.boot.module.cylinder.api.mapper;

import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.cylinder.api.dto.EquipQuestionNumCountDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface DPStatisticsMapper {

    String getOrgCodeByCompanyCode(@Param("cityCode") String cityCode);

    List<Map<String, Object>> selectByOrgAndMainBody(@Param("orgCode") String orgCode, @Param("mainBodyNameList") List<String> mainBodyNameList,
                                                     @Param("startDate") String startDate, @Param("status") String status);

    List<Map<String, Object>> selectByOrgAndProblemType(@Param("orgCode") String orgCode, @Param("enumNameList") List<String> enumNameList,
                                                        @Param("startDate") String startDate, @Param("sourceType") String sourceType, @Param("equipType") String equipType);

    List<Map<String, Object>> getIssueCountByMonth(@Param("orgCode") String orgCode, @Param("year") String year, @Param("status") String status);
    List<Map<String, Object>> getIssueCountByDate(@Param("orgCode") String orgCode, @Param("year") String year, @Param("status") String status);

    int countByOrgCode(@Param("orgCode") String orgCode, @Param("now") String now);

    List<Map<String, String>> getOrgCodeAndCompanyCodesByCompanyCodes(@Param("regionCodes") List<Integer> regionCodes);

    List<Map<String, Object>> countByOrgCodes(@Param("orgCodes") List<String> orgCodes, @Param("now") String now);

    List<Map<String, Object>> issueMonthList(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> issueProblemLevelCount(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> issueCompanyTop(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> issueChildrenCityCountTop(@Param("orgCodes") List<String> orgCodes, @Param("now") String now, @Param("status") String status);

    List<Map<String, Object>> issueCountTopByProblemType(@Param("orgCode") String orgCode, @Param("status") String status);

    List<EquipQuestionNumCountDto> queryEquipQuestionList(@Param("orgCode")String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);
}
