package com.yeejoin.amos.boot.module.jg.biz.reminder.core.event;

import lombok.Getter;
import org.springframework.context.ApplicationEvent;

import java.util.Set;

/**
 * 数据质量等级计算消息
 */
@Getter
public class EquipCreateOrEditEvent extends ApplicationEvent {

    /**
     * 业务类型
     */
    private final String bizType;

    /**
     * 变更的设备/装置集合
     */
    private final Set<String> updatedIds;

    /**
     * 资源类型区分设备还是装置
     */
    private final EquipType equipType;

    public EquipCreateOrEditEvent(Object source, String bizType, Set<String> updatedIds, EquipType equipType) {
        super(source);
        this.bizType = bizType;
        this.updatedIds = updatedIds;
        this.equipType = equipType;
    }

    public enum EquipType {
        equip,
        project
    }
}
