package com.yeejoin.amos.boot.module.statistics.api.dto;

import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.Map;

/**
 * 安全追溯问题
 *
 * @author system_generator
 * @date 2024-05-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SafetyProblemTracingDto", description = "安全追溯问题")
public class SafetyProblemTracingDto extends DPFilterParamForDetailDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;


    @ApiModelProperty(value = "更新时间")
    protected Date recDate;


    @ApiModelProperty(value = "更新人id")
    protected String recUserId;


    @ApiModelProperty(value = "更新人")
    protected String recUserName;


    @ApiModelProperty(value = "问题编号")
    private String problemNum;

    @ApiModelProperty(value = "问题类型（维保超期、检验超期、资质超期等）")
    private String problemType;

    @ApiModelProperty(value = "问题类型图片")
    private String problemTypePic;

    @ApiModelProperty(value = "问题来源类型（1个人、2设备、3企业）")
    private String sourceType;

    @ApiModelProperty(value = "问题来源ID（个人ID、设备ID、企业ID）")
    private String sourceId;

    @ApiModelProperty(value = "问题描述")
    private String problemDesc;

    @ApiModelProperty(value = "问题产生查询开始时间")
    private String problemTimeStart;

    @ApiModelProperty(value = "问题产生时间")
    private Date problemTime;

    @ApiModelProperty(value = "问题产生查询结束时间")
    private String problemTimeEnd;

    @ApiModelProperty(value = "主体单位名称")
    private String principalUnit;

    @ApiModelProperty(value = "主体单位统一代码")
    private String principalUnitCode;

    @ApiModelProperty(value = "主体单位类型（使用、安改维、检验检测等）")
    private String principalUnitType;

    @ApiModelProperty(value = "管辖机构名称")
    private String governingBody;

    @ApiModelProperty(value = "管辖机构单位代码")
    private String governingBodyCode;

    @ApiModelProperty(value = "管辖机构组织机构代码（例如50*60*70）")
    private String governingBodyOrgCode;

    @ApiModelProperty(value = "主体单位所属区域名称（陕西省/西安市/莲湖区）")
    private String regionName;

    @ApiModelProperty(value = "所属区域代码（6100000/6100010/6100011）")
    private String regionCode;

    @ApiModelProperty(value = "问题状态（0未处理、1已处理）")
    private String problemStatus;

    @ApiModelProperty(value = "问题状态代码（0未处理、1已处理）")
    private String problemStatusCode;

    @ApiModelProperty(value = "问题状态对象")
    private Map<String, String> problemStatusObj;

    @ApiModelProperty(value = "更新人员")
    private String recUser;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人")
    private String createUser;

    @ApiModelProperty(value = "企业负责人")
    private String unitCharger;

    @ApiModelProperty(value = "企业负责人联系电话")
    private String unitChargerPhone;

    @ApiModelProperty(value = "设备监管码")
    private String equipSuperviseCode;

    @ApiModelProperty(value = "设备种类")
    private String equipList;

    @ApiModelProperty(value = "人员名称")
    private String userName;

    @ApiModelProperty(value = "人员电话")
    private String userPhone;

    @ApiModelProperty(value = "人员岗位")
    private String userPost;

    @ApiModelProperty(value = "扩展信息")
    private String extraInfo;

    @ApiModelProperty(value = "设备种类代码")
    private String equipListCode;

    @ApiModelProperty(value = "问题类型代码（维保超期、检验超期、资质超期等）")
    private String problemTypeCode;

    @ApiModelProperty(value = "问题来源类型code（1个人、2设备、3企业）")
    private String sourceTypeCode;

    @ApiModelProperty(value = "问题等级（一级、二级、三级）")
    private String problemLevel;

    @ApiModelProperty(value = "问题等级code")
    private String problemLevelCode;

}
