package com.yeejoin.amos.boot.module.cylinder.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 
 * <pre>
 * 通用视频协议枚举
 * </pre>
 *
 */
@Getter
@AllArgsConstructor
public enum CommonVideoEnum {

	HLS("2", "hls"),
    IMG("3", "img");

    private String code;
    private String name;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
	public static CommonVideoEnum getEnum(String code)
	{
		for (CommonVideoEnum status : CommonVideoEnum.values())
		{
			if (status.getCode().equals(code))
			{
				return status;
			}
		}
		return null;
	}
}

