package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.jg.biz.service.IPdfService;
import com.yeejoin.amos.boot.module.jg.biz.utils.PdfUtils;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.awt.*;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

/**
 * @author Administrator
 */
@Component
public class PdfServiceImpl implements IPdfService {

    @Value("${fileserver.domain}")
    private String fileServerUrl;


    @Override
    public String signToPdf(String inputPdfPath, String text) {
        String newFilePath = "";
        String filePath = fileServerUrl + inputPdfPath;
        File imageFile = null, file = null;
        try {
            imageFile = File.createTempFile("temp", ".png");
            PdfUtils.generatorImageWithText(imageFile, 100, 50, text, Color.RED);
            file = PdfUtils.addImageToPdf(filePath, 100, 50, imageFile.getAbsolutePath());
            String fileName = extractFileNameFromPath(inputPdfPath);
            MultipartFile mockMultipartFile = new MockMultipartFile(fileName, fileName, ContentType.APPLICATION_OCTET_STREAM.toString(), new FileInputStream(file));
            FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFileFree(mockMultipartFile, "upload/tzs/pdf");
            Map<String, String> map = result.getResult();
            for (Map.Entry<String, String> fileResult : map.entrySet()) {
                newFilePath = fileResult.getKey();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (imageFile != null) {
                imageFile.deleteOnExit();
            }
            if (file != null) {
                file.deleteOnExit();
            }
        }
        return newFilePath;
    }

    @Override
    public String signToPdfWaterPrint(String inputPdfPath, String text) {
        String newFilePath = "";
        String filePath = fileServerUrl + inputPdfPath;
        File file = null;
        try {
            file = PdfUtils.addFullPageWatermark(filePath, "已作废");
            String fileName = extractFileNameFromPath(inputPdfPath);
            MultipartFile mockMultipartFile = new MockMultipartFile(fileName, fileName, ContentType.APPLICATION_OCTET_STREAM.toString(), new FileInputStream(file));
            FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFileFree(mockMultipartFile, "upload/tzs/pdf");
            Map<String, String> map = result.getResult();
            for (Map.Entry<String, String> fileResult : map.entrySet()) {
                newFilePath = fileResult.getKey();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (file != null) {
                file.deleteOnExit();
            }
        }
        return newFilePath;
    }


    private static String extractFileNameFromPath(String path) {
        // 查找最后一个斜杠的位置
        int lastIndex = path.lastIndexOf('/');
        // 如果找不到斜杠，说明没有目录，整个字符串就是文件名
        if (lastIndex == -1) {
            return path;
        }
        // 否则，从最后一个斜杠之后开始提取文件名
        return path.substring(lastIndex + 1);
    }

}
