package com.yeejoin.amos.boot.module.jyjc.biz.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jyjc.biz.config.XidFeignConfiguration;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.yeejoin.amos.feign.systemctl.model.*;

import java.util.List;

/**
 * systemctl-消息
 */
@FeignClient(contextId = "jyjc", name = "${privilege.feign.name:AMOS-API-PRIVILEGE}", path = "/systemctl/v1/message", configuration = {XidFeignConfiguration.class})
public interface MessageFeignClient {


    /**
     * 根据类型统计
     */
    @RequestMapping(value = "/countByMsgType/{msgTypes}", method = RequestMethod.GET)
    FeignClientResult<Integer> countByMsgType(@PathVariable("msgTypes") String msgTypes, @RequestParam(value = "terminal") String terminal,
                                              @RequestParam(value = "category", required = false) String category, @RequestParam(value = "isRead", required = false) Boolean isRead) throws InnerInvokException;


    /**
     * 创建消息
     */
    @RequestMapping(value = "", method = RequestMethod.POST)
    FeignClientResult<MessageModel> create(@RequestBody MessageModel arg0) throws InnerInvokException;


    /**
     * 批量删除消息
     */
    @RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
    FeignClientResult<List<Long>> delete(@PathVariable("ids") String ids) throws InnerInvokException;


    /**
     * 极光推送删除别名
     */
    @RequestMapping(value = "/delete/alias", method = RequestMethod.GET)
    FeignClientResult<Boolean> deleteAlias(@RequestParam(value = "alias") String alias) throws InnerInvokException;


    /**
     * 根据类型查询
     */
    @RequestMapping(value = "/listByMsgType/{msgTypes}", method = RequestMethod.GET)
    FeignClientResult<Page> listByType(@PathVariable("msgTypes") String msgTypes, @RequestParam(value = "body", required = false) String body, @RequestParam(value = "terminal") String terminal, @RequestParam(value = "category", required = false) String category, @RequestParam(value = "createDate", required = false) String createDate, @RequestParam(value = "current") int current, @RequestParam(value = "size") int size) throws InnerInvokException;


    /**
     * 全部查询
     */
    @RequestMapping(value = "/all", method = RequestMethod.GET)
    FeignClientResult<List> queryForAll(@RequestParam(value = "msgType", required = false) String msgType, @RequestParam(value = "terminal") String terminal, @RequestParam(value = "category", required = false) Integer category, @RequestParam(value = "body", required = false) String body) throws InnerInvokException;


    /**
     * 分页查询
     */
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    FeignClientResult<Page> queryForPage(@RequestParam(value = "msgType") String msgType, @RequestParam(value = "terminal") String terminal, @RequestParam(value = "category", required = false) Integer category, @RequestParam(value = "body", required = false) String body, @RequestParam(value = "current") int current, @RequestParam(value = "size") int size) throws InnerInvokException;


    /**
     * 查询已有数据
     */
    @RequestMapping(value = "/page/existData", method = RequestMethod.GET)
    FeignClientResult<Page> queryForPageExistData(@RequestParam(value = "current", required = false) Integer current, @RequestParam(value = "terminal") String terminal, @RequestParam(value = "category", required = false) Integer category, @RequestParam(value = "size", required = false) Integer size) throws InnerInvokException;


    /**
     * 极光推送注册别名
     */
    @RequestMapping(value = "/register/alias", method = RequestMethod.GET)
    FeignClientResult<Boolean> registerAlias(@RequestParam(value = "registrationId") String registrationId, @RequestParam(value = "alias") String alias) throws InnerInvokException;


    /**
     * 查询指定消息
     */
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
    FeignClientResult<MessageModel> seleteOne(@PathVariable("sequenceNbr") Long sequenceNbr) throws InnerInvokException;


    /**
     * 更新消息
     */
    @RequestMapping(value = "", method = RequestMethod.PUT)
    FeignClientResult<Void> update(@RequestBody MessageModel arg0) throws InnerInvokException;


    /**
     * 批量修改已读
     */
    @RequestMapping(value = "/updateBatch", method = RequestMethod.GET)
    FeignClientResult<Boolean> updateBatch(@RequestParam(value = "terminal") String terminal, @RequestParam(value = "userId", required = false) String userId, @RequestParam(value = "category", required = false) Integer category, @RequestParam(value = "msgTypes", required = false) String msgTypes) throws InnerInvokException;


    /**
     * 更新消息为已读
     */
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    FeignClientResult<MessageModel> updateIsRead(@PathVariable("sequenceNbr") Long sequenceNbr) throws InnerInvokException;

    /**
     * 根据relationId 查询信息集合
     */
    @RequestMapping(value = "/listByRelationId", method = RequestMethod.GET)
    FeignClientResult<List<MessageModel>> listByRelationId(@RequestParam("relationId") String relationId) throws InnerInvokException;
}