package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.statistcs.biz.service.ITzsCustomFilterContentService;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.TzsCustomFilterContentServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.dto.TzsCustomFilterContentDto;
import com.yeejoin.amos.boot.module.statistics.api.entity.TzsCustomFilterContent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 用户保存的自定义筛选内容表
 *
 * @author system_generator
 * @date 2025-06-24
 */
@RestController
@Api(tags = "用户保存的自定义筛选内容表Api")
@RequestMapping(value = "/tzs-custom-filter-content")
public class TzsCustomFilterContentController extends BaseController {

    @Autowired
    TzsCustomFilterContentServiceImpl tzsCustomFilterContentServiceImpl;

    @Autowired
    ITzsCustomFilterContentService tzsCustomFilterContentService;

    /**
     * 新增用户保存的自定义筛选内容表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增用户保存的自定义筛选内容表", notes = "新增用户保存的自定义筛选内容表")
    public ResponseModel<TzsCustomFilterContentDto> save(@RequestBody TzsCustomFilterContentDto model) {
        model = tzsCustomFilterContentService.save(model, getSelectedOrgInfo().getCompany());
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新用户保存的自定义筛选内容表", notes = "根据sequenceNbr更新用户保存的自定义筛选内容表")
    public ResponseModel<TzsCustomFilterContentDto> updateBySequenceNbrTzsCustomFilterContent(@RequestBody TzsCustomFilterContentDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(tzsCustomFilterContentServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除用户保存的自定义筛选内容表", notes = "根据sequenceNbr删除用户保存的自定义筛选内容表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(tzsCustomFilterContentServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据filterType查询
     *
     * @param filterType 筛选类型
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectList")
    @ApiOperation(httpMethod = "GET", value = "根据filterType查询单个用户保存的自定义筛选内容表", notes = "根据filterType查询单个用户保存的自定义筛选内容表")
    public ResponseModel<List<TzsCustomFilterContent>> queryByFilterType(@RequestParam(value = "filterType") String filterType) {
        return ResponseHelper.buildResponse(tzsCustomFilterContentServiceImpl.queryByFilterType(filterType));
    }



}
