package com.yeejoin.amos.boot.module.ys.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;

/**
 * <pre>
 * 维保到期预警枚举
 * </pre>
 */

@Getter
@AllArgsConstructor
public enum MaintenanceExpiredEarlyWarningEnum {
    // 设备
    QP("2300", "气瓶", "cylinderMaintenanceExpiredEarlyWarning"),
    QZJX("4000", "起重机械", "liftingMachineryMaintenanceExpiredEarlyWarning"),
    KYSD("9000", "客运索道", "passengerRopeWayMaintenanceExpiredEarlyWarning"),
    YLSS("6000", "游乐设施", "amusementFacilitiesMaintenanceExpiredEarlyWarning"),
    GL("1000", "锅炉", "boilerMaintenanceExpiredEarlyWarning"),
    YLGD("8000", "压力管道", "pressurePipeMaintenanceExpiredEarlyWarning"),
    CNJDCL("5000", "场内机动车辆", "yardMotorVehicleMaintenanceExpiredEarlyWarning"),
    // 体系建设统计
    TXJS("0001", "体系建设", "systemConstructionStatistics"),
    // 教育培训统计
    JYPX("0002", "教育培训", "educationAndTrainingStatistics");

    private String typeCode; // 设备类型代码 || 业务类型代码
    private String typeName; // 设备类型名称
    private String groupCode; // 分组代码

    /**
     * 根据设备类型代码获取对应的枚举实例。
     *
     * @param equTypeCode 设备类型代码
     * @return 对应的枚举实例，如果不存在则返回 Optional.empty()
     */
    public static Optional<MaintenanceExpiredEarlyWarningEnum> getEnum(String equTypeCode) {
        for (MaintenanceExpiredEarlyWarningEnum status : MaintenanceExpiredEarlyWarningEnum.values()) {
            if (status.getTypeCode().equals(equTypeCode)) {
                return Optional.of(status);
            }
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return String.format("MaintenanceExpiredEarlyWarningEnum{equTypeCode='%s', equTypeName='%s', groupCode='%s'}",
                typeCode, typeName, groupCode);
    }
}


