package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.module.statistcs.biz.service.ITzsCustomFilterContentService;
import com.yeejoin.amos.boot.module.statistics.api.dto.TzsCustomFilterContentDto;
import com.yeejoin.amos.boot.module.statistics.api.entity.TzsCustomFilterContent;
import com.yeejoin.amos.boot.module.statistics.api.mapper.TzsCustomFilterContentMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;

/**
 * 用户保存的自定义筛选内容表服务实现类
 *
 * @author system_generator
 * @date 2025-06-24
 */
@Service
public class TzsCustomFilterContentServiceImpl extends BaseService<TzsCustomFilterContentDto, TzsCustomFilterContent, TzsCustomFilterContentMapper> implements ITzsCustomFilterContentService {

    @Override
    public TzsCustomFilterContentDto save(TzsCustomFilterContentDto model, CompanyBo company) {
        model.setOrgCode(company.getOrgCode());
        model.setOrgName(company.getCompanyName());
        model.setCreateUserId(RequestContext.getExeUserId());
        model.setFilterContent(JSONObject.toJSONString(model.getFilterContent()));
        model.setFilterResult(ObjectUtils.isEmpty(model.getFilterResult()) ? null : JSONObject.toJSONString(model.getFilterResult()));
        model.setCreateTime(new Date());
        return this.createWithModel(model);
    }

    @Override
    public List<TzsCustomFilterContent> queryByFilterType(String filterType) {
        LambdaQueryWrapper<TzsCustomFilterContent> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TzsCustomFilterContent::getFilterType, filterType);
        queryWrapper.eq(TzsCustomFilterContent::getCreateUserId, RequestContext.getExeUserId());
        return this.lambdaQuery().getBaseMapper().selectList(queryWrapper);
    }
}