package com.yeejoin.amos.patrol.business.dao.repository;

import com.yeejoin.amos.patrol.dao.entity.MsgSubscribe;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("msgSubscribeDao")
public interface IMsgSubscribeDao extends BaseDao<MsgSubscribe, Long> {

	@Query("SELECT m FROM MsgSubscribe m WHERE m.orgCode =?1 AND m.userId = ?2")
	List<MsgSubscribe> findMsgSubscribes(String orgCode, String userId);
	
	@Query("SELECT m FROM MsgSubscribe m WHERE  m.userId = ?1")
	List<MsgSubscribe> findMsgSubscribes(String userId);
	
	@Query("SELECT m FROM MsgSubscribe m WHERE m.msgType =?1 AND m.userId = ?2")
	MsgSubscribe getMsgSubscribeByTypeAndUserId(String msgType, long userId);

	@Modifying
	@Transactional
	@Query(value="DELETE FROM p_msg_subscribe WHERE user_id IN (?1)", nativeQuery = true)
	void delMsgSubscribeByUserId(List<Long> userIds);
	
	@Query(value = "SELECT COUNT(*) FROM p_msg_subscribe WHERE user_id = ?1", nativeQuery = true)
	Long countByUserId(String userId);
}
