package com.yeejoin.amos.api.openapi.face.orm.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipRegistrationInfo;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Set;

/**
 * 特种设备基本信息-注册登记信息  Mapper 接口
 *
 * @author Zhang Yingbin
 * @date 2022-07-19
 */
public interface MidEquipRegistrationInfoMapper extends BaseMapper<MidEquipRegistrationInfo> {

    @DS("tzs")
    @Query("SELECT DISTINCT r.*  FROM idx_biz_jg_use_info i, idx_biz_jg_register_info r  WHERE i.data_source like 'jg%'  AND i.RECORD = r.RECORD  AND r.EQU_CODE IN :values")
    List<MidEquipRegistrationInfo> getUseInfoByEquipCode(@Param("values") Set<String> sequenceCodes);
}
