package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

@Getter
public enum IssueMainBodyEnum {
    //个人
    PERSON("个人","1"),
    //企业
    COMPANY("企业","2"),
    //设备
    EQUIPMENT("设备","3"),
    //气瓶
    CYLINDER("气瓶","4"),

    ;

    String name;
    String code;

    private IssueMainBodyEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static List<HashMap<String,String>> getEnumList() {
        List<HashMap<String, String>> list = new ArrayList<>();
        for (IssueMainBodyEnum testEnum : EnumSet.allOf(IssueMainBodyEnum.class)) {
            HashMap<String, String> map = new HashMap<>();
            map.put(testEnum.name,testEnum.code.toString());
            list.add(map);
        }
        return list;
    }

    public static List<String> getEnumNameList() {
        List<String> list = new ArrayList<>();
        for (IssueMainBodyEnum testEnum : EnumSet.allOf(IssueMainBodyEnum.class)) {
            list.add(testEnum.getName());
        }
        return list;
    }

}
