package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.SafetyProblemTracingDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SafetyProblemTracingGenServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SafetyProblemTracingServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 安全追溯问题
 *
 * @author system_generator
 * @date 2024-05-21
 */
@RestController
@Api(tags = "安全追溯问题Api")
@RequestMapping(value = "/safety-problem-tracing")
public class SafetyProblemTracingController extends BaseController {

    @Autowired
    SafetyProblemTracingServiceImpl safetyProblemTracingServiceImpl;

	@Autowired
	SafetyProblemTracingGenServiceImpl safetyProblemTracingGenService;

    /**
     * 新增安全追溯问题
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增安全追溯问题", notes = "新增安全追溯问题")
	public ResponseModel<SafetyProblemTracingDto> save(@RequestBody SafetyProblemTracingDto model) {
	    model = safetyProblemTracingServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新安全追溯问题", notes = "根据sequenceNbr更新安全追溯问题")
	public ResponseModel<SafetyProblemTracingDto> updateBySequenceNbrSafetyProblemTracing(@RequestBody SafetyProblemTracingDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除安全追溯问题", notes = "根据sequenceNbr删除安全追溯问题")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个安全追溯问题",  notes = "根据sequenceNbr查询单个安全追溯问题")
	public ResponseModel<SafetyProblemTracingDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.selectOne(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/page")
	@ApiOperation(httpMethod = "POST",value = "分页查询安全追溯问题",  notes = "分页查询安全追溯问题")
	public ResponseModel<Page<SafetyProblemTracingDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size, @RequestBody(required = false) SafetyProblemTracingDto problemModel) {
		ReginParams loginParams = getSelectedOrgInfo();
		CompanyBo company = loginParams.getCompany();
		if (company.getLevel().equals("company")) {
			return ResponseHelper.buildResponse(new Page<>());
		}
	    Page<SafetyProblemTracingDto> page = new Page<>();
	    page.setCurrent(current);
	    page.setSize(size);
		problemModel.setGoverningBodyOrgCode(loginParams.getCompany().getOrgCode());
	    return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.queryForSafetyProblemTracingPage(page, problemModel));
	}

	/**
	 * 设备问题列表分页查询
	 *
	 * @param current 当前页
	 * @param size 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/equipId/page")
	@ApiOperation(httpMethod = "GET",value = "设备问题列表分页查询",  notes = "设备问题列表分页查询")
	public ResponseModel<Page<SafetyProblemTracingDto>> queryProblemPageByEquipId(@RequestParam(value = "current") int current,@RequestParam
			(value = "size") int size, @RequestParam(value = "record") String equipId) {
		Page<SafetyProblemTracingDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.queryProblemPageByEquipId(page, equipId));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询安全追溯问题",   notes = "列表全部数据查询安全追溯问题")
	@GetMapping(value = "/list")
	public ResponseModel<List<SafetyProblemTracingDto>> selectForList() {
	    return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.queryForSafetyProblemTracingList());
	}

	/**
	 * 根据问题ID及问题类型查询关联设备列表
	 *
	 * @param problemId 问题Id
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据问题ID及问题类型查询关联设备列表",   notes = "根据问题ID及问题类型查询关联设备列表")
	@GetMapping(value = "/equip/list")
	public ResponseModel<Page<Map<String, Object>>> queryEquipListProblemById(@RequestParam(value = "current") int current,@RequestParam
			(value = "size") int size, @RequestParam(value = "sequenceNbr") String problemId) {
		Page<Map<String, Object>> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.queryEquipListByProblemId(page, problemId));
	}

	/**
	 * 根据问题ID及问题类型查询关联企业
	 *
	 * @param problemId 问题Id
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据问题ID及问题类型查询关联企业",   notes = "根据问题ID及问题类型查询关联企业")
	@GetMapping(value = "/unit/list")
	public ResponseModel<Page<Map<String, Object>>> queryPrincipalUnitByProblemId(@RequestParam(value = "current") int current,@RequestParam
			(value = "size") int size, @RequestParam(value = "sequenceNbr") String problemId) {
		Page<Map<String, Object>> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(safetyProblemTracingServiceImpl.queryPrincipalUnitByProblemId(page, problemId));
	}

	/**
	 * test1
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "生成维保、检验检测超期数据",   notes = "生成维保、检验检测超期数据")
	@GetMapping(value = "/gen/test1")
	public ResponseModel<String> test1() {
		safetyProblemTracingGenService.executeSafetyProblemCheck();
		return ResponseHelper.buildResponse("success");
	}

	/**
	 * test2
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "生成检验检测超期数据",   notes = "生成检验检测超期数据")
	@GetMapping(value = "/gen/test2")
	public ResponseModel<String> test2() {
		safetyProblemTracingGenService.executeInspectionCheck();
		return ResponseHelper.buildResponse("success");
	}

	/**
	 * test3
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "生成维保超期数据",   notes = "生成维保超期数据")
	@GetMapping(value = "/gen/test3")
	public ResponseModel<String> test3() {
		safetyProblemTracingGenService.executeMaintenanceCheck();
		return ResponseHelper.buildResponse("success");
	}
}
