package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.event.SafetyProblemEvent;
import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import com.yeejoin.amos.boot.module.jg.biz.listener.SafetyProblemTopicMessage;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SafetyProblemTracingServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * WBCQEventHandler 类实现了 SafetyProblemEventHandler 接口，
 * 用于处理维保超期安全问题事件。
 */
@Component
public class WBCQEventHandler implements SafetyProblemEventHandler {

    SafetyProblemTracingServiceImpl safetyProblemTracingService;

    @Autowired
    public WBCQEventHandler(SafetyProblemTracingServiceImpl safetyProblemTracingService) {
        this.safetyProblemTracingService = safetyProblemTracingService;
    }

    /**
     * 处理安全问题事件。
     *
     * @param event 安全问题事件对象，包含事件的详细信息。
     *              该参数用于描述发生的安全问题事件。
     */
    @Override
    public void handle(SafetyProblemEvent event) {
        // 此处为处理安全问题事件的逻辑代码
        JSONObject jsonObject = JSONObject.parseObject(event.getMessage().toString());
        generateProblem(jsonObject);
    }

    private void generateProblem(JSONObject jsonObject) {
        SafetyProblemTopicMessage.generateProblem(jsonObject, SafetyProblemTypeEnum.WBCQ, safetyProblemTracingService);
    }
}

