package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.DPSubServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/dp/sub")
@Api(tags = "大屏二级弹窗")
public class DPSubController {


    private DPSubServiceImpl subService;

    public DPSubController(DPSubServiceImpl subService) {
        this.subService = subService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "动态详情页", notes = "动态详情页")
    @PostMapping(value = "/{template}")
    public ResponseModel<JSONObject> commonQuery(@PathVariable String template, @RequestBody Map<String, Object> param) {
        if (template.equals("company")){
            Assert.notNull(param.get("useUnitCode"), "企业统一信用代码不能为空");
        } else if (template.equals("equip")){
            param.put("record", param.get("SEQUENCE_NBR"));
            param.put("equList", param.get("EQU_LIST_CODE"));
            Assert.notNull(param.get("record"), "设备ID不能为空");
            Assert.notNull(param.get("equList"), "设备种类不能为空");
            template = template + "_" + param.get("equList");
        } else {
            throw new RuntimeException("暂无模板");
        }
        return ResponseHelper.buildResponse(subService.commonQuery(template, param));
    }
}
