package com.yeejoin.precontrol.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 奖励兑换vo
 * @author wbin
 * @date 2021-04-06
 */
@Data
public class RewardExchangeWechatVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "兑换批次")
    private String batchNo;

    @ApiModelProperty(value = "兑换人id")
    private Long personId;

    @ApiModelProperty(value = "兑换人姓名")
    private String personName;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "兑换金额")
    private BigDecimal money;

    @ApiModelProperty(value = "发布兑换任务的用户id")
    private Long createUserId;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "兑换时间")
    private Date exchangeDate;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "任务类型")
    private String nature;

    @ApiModelProperty(value = "任务时间")
    private Date taskDate;
}
