package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.TaskPersonDto;
import com.yeejoin.precontrol.common.dto.TaskSalaryConfirmDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskSalaryConfirm;
import com.yeejoin.precontrol.common.enums.StatusEnum;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.param.PersonParam;
import com.yeejoin.precontrol.common.service.IPersonService;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
import com.yeejoin.precontrol.common.service.ITaskSalaryConfirmService;
import com.yeejoin.precontrol.common.vo.PersonVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmOneVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmVo;
import com.yeejoin.precontrol.controller.publics.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

/**
 * 薪资确认任务表
 *
 * @author duanwei
 * @date 2020-12-08
 */
@RestController
@Api(tags = "薪资确认任务表Api")
@RequestMapping(value = "/task-salary-confirm", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TaskSalaryConfirmController extends BaseController {

	@Autowired
	ITaskSalaryConfirmService iTaskSalaryConfirmService;
	@Autowired
	ITaskPersonService iTaskPersonService;
	@Autowired
	IPersonService personService;

	/**
	 * 新增薪资确认任务表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增薪资确认任务表", notes = "新增薪资确认任务表")
	public Task saveTaskSalaryConfirm(HttpServletRequest request,
			@RequestBody TaskSalaryConfirmDto taskSalaryConfirmDto) throws ParseException {
		Person person = getPerson();
		return iTaskSalaryConfirmService.save(taskSalaryConfirmDto, person);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iTaskSalaryConfirmService.removeById(id);
	}

	/**
	 * 修改薪资确认任务表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改薪资确认任务表", notes = "修改薪资确认任务表")
	public boolean updateByIdTaskSalaryConfirm(HttpServletRequest request,
			@RequestBody TaskSalaryConfirm taskSalaryConfirm) {
		return iTaskSalaryConfirmService.updateById(taskSalaryConfirm);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public TaskSalaryConfirmVo selectById(HttpServletRequest request, @PathVariable Long id) {
		return iTaskSalaryConfirmService.queryById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public Object listPage(CommonPageableDto pageable, TaskSalaryConfirmDto taskSalaryConfirmDto) {
		IPage<TaskSalaryConfirmVo> iPage = iTaskSalaryConfirmService.pageInfo(pageable, taskSalaryConfirmDto);
		return iPage;
	}

	/**
	 * 确认薪资
	 * 
	 * @return
	 */
	@RequestMapping(value = "/confirm", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "确认薪资", notes = "确认薪资")
	public boolean confirm(@RequestBody TaskPersonDto taskPersonDto) {
		return iTaskSalaryConfirmService.confirm(taskPersonDto);
	}

	/**
	 * 薪资确认我的待办
	 * 
	 * @return
	 */
	@RequestMapping(value = "/todo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "我的待办列表分页查询", notes = "我的待办列表分页查询")
	public Object todo(CommonPageableDto pageable, TaskSalaryConfirmOneVo taskSalaryConfirmOneVo) {
		Person person = personService.getById(getPerson().getId());
		//分包商只看自己的----userId;江西电建查看项目部的----orgCode
		if (person.getIsJxdj() == 0) {
			taskSalaryConfirmOneVo.setPersonId(person.getId());
			taskSalaryConfirmOneVo.setOrgCode("");
		}else {
			taskSalaryConfirmOneVo.setOrgCode(person.getOrgCode());
		}
		return iTaskSalaryConfirmService.todo(pageable, taskSalaryConfirmOneVo);
	}

	/**
	 * 薪资确认我的待办详情
	 * 
	 * @return
	 */
	@RequestMapping(value = "/todo/{taskPersonId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "我的待办详情查询", notes = "我的待办详情查询")
	public Object todo(@PathVariable long taskPersonId) {
		Long personId = getUserInfo().getSequenceNbr();
		return iTaskSalaryConfirmService.todoDetail(taskPersonId,personId);
	}

	/**
	 * 薪资确认个人重新修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/person/salary-modify", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "薪资确认个人重新修改", notes = "薪资确认个人重新修改")
	public Object salaryModify(TaskPerson taskPerson) {
		taskPerson.setReadStatus(StatusEnum.UNFINISHED.getValue());
		return iTaskPersonService.updateById(taskPerson);
	}

	/**
	 * 薪资确认人员导入
	 * 
	 * @return
	 * @throws Exception payAllCount
	 */
	@RequestMapping(value = "/person/import", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "薪资确认人员导入", notes = "薪资确认人员导入")
	public Object personImport(
			@ApiParam(value = "导入数据文件", required = true) @RequestBody(required = true) MultipartFile file)
			throws Exception {
		String fileName = file.getOriginalFilename();
		if (!fileName.endsWith(".xls")) {
			throw new BaseException("文件格式错误");
		}
		return iTaskSalaryConfirmService.personImport(file);
	}

	/**
	 * 薪资确认已发起的人员
	 * 
	 * @return
	 * @throws Exception payAllCount
	 */
	@RequestMapping(value = "/{id}/person", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "薪资确认已发起的人员", notes = "薪资确认已发起的人员")
	public Object persons(CommonPageableDto pageable, PersonParam personParam, @PathVariable("id") Long id) {
		IPage<PersonVo> page = iTaskSalaryConfirmService.persons(id, pageable, personParam);
		return page;
	}

	/**
	 * 薪资确认重新发起
	 * 
	 * @return
	 * @throws Exception payAllCount
	 */
	@RequestMapping(value = "/resend", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "薪资确认重新发起", notes = "薪资确认重新发起")
	public boolean resend(@RequestBody TaskSalaryConfirmOneVo salaryConfirmOneVo) {
		return iTaskSalaryConfirmService.resend(salaryConfirmOneVo);
	}

	/**
	 * 薪资人数统计
	 * 
	 * @return
	 */
	@RequestMapping(value = "/statistics/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "薪资人数统计", notes = "薪资人数统计")
	public Object statistics(@PathVariable("id") Long id) {
		return iTaskSalaryConfirmService.statistics(id);
	}

	/**
	 * 获取已发放比例
	 */
	@RequestMapping(value = "/paidRatio", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "薪资人数统计", notes = "薪资人数统计")
	public Object statistics(Long projectId, Long companyId) {
		Map<String, Integer> map = new HashMap<>();
		map.put("ratio", iTaskSalaryConfirmService.paidRatio(projectId, companyId));
		return map;
	}

	/**
	 * 是否有未阅读消息
	 */
	@RequestMapping(value = "/hasfirstRead", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "是否有未阅读消息", notes = "是否有未阅读消息")
	public Object hasfirstRead() {
		Person person = getPerson();
		return iTaskSalaryConfirmService.hasFirstRead(person.getId());
	}

	/**
	 * 阅读消息
	 */
	@RequestMapping(value = "/dofirstRead", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = " 阅读消息", notes = " 阅读消息")
	public Object dofirstRead(@RequestBody Long id) {
		return iTaskSalaryConfirmService.doFirstRead(id);
	}
}
