package com.yeejoin.amos.supervision.business.service.intfc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportDto;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportParamDto;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.dao.entity.PlanTask;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

public interface ICheckReportService {
    void genCheckReport(PlanTask planTask) throws ParseException;

    /**
     * 分页查询检查报告列表
     *
     * @param page
     * @param queryParam
     */
    IPage<CheckReportDto> pageList(Page page, CheckReportParamDto queryParam);

    /**
     * 根据报告id获取报告详情
     *
     * @param id
     * @return
     */
    CheckReportDto getDetailById(String id);

    /**
     * 生成指定报告的word文档
     *
     * @param response
     * @param reportId
     * @return
     */
    void getCheckReportDocx(HttpServletResponse response, String reportId) throws Exception;
}
