package com.yeejoin.amos;

import com.yeejoin.amos.supervision.mqtt.AmosMqttListener;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;

/**
 * <pre>
 * 防火监督服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: SupervisionApplicationStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableJpaAuditing
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({"org.typroject", "com.yeejoin.amos"})
@MapperScan(basePackages = {"com.yeejoin.amos.supervision.business.dao.mapper", "org.typroject.tyboot.core.auth.face" +
        ".orm.dao", "com.yeejoin.amos.boot.biz.common.dao.mapper"})
public class SupervisionApplication {

    private static final Logger logger = LoggerFactory.getLogger(SupervisionApplication.class);

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    private AmosMqttListener amosMqttListener;

    @Value("${jcs.company.topic}")
    private String airportTopic;

    /**
     * 启动amosop-server
     *
     * @param args
     * @throws IOException
     * @throws URISyntaxException
     */
    public static void main(String[] args) throws UnknownHostException {
        logger.info("start Service..........");
        SpringApplication application = new SpringApplication(SupervisionApplication.class);
        ConfigurableEnvironment environment = new StandardEnvironment();
        int randomClientId = new SecureRandom().nextInt(65536 - 1024) + 1024;
        environment.getPropertySources().addFirst(new MapPropertySource("securityRandomSource",
                Collections.singletonMap("security-random-int", randomClientId)));
        application.setEnvironment(environment);
        GlobalExceptionHandler.setAlwaysOk(true);
        application.run();
        String appName = environment.getProperty("spring.application.name");
        logger.info(
                "\n----------------------------------------------------------\n\t"
                        + "Application {} is running!\n"
                        + "----------------------------------------------------------\n"
                , appName
        );
    }

    @Bean
    RestTemplate initRestTemplate() {
        return new RestTemplate();
    }


    /**
     * 初始化MQTT
     * @throws MqttException
     */
    @Bean
    void initMqtt() {
        try {
            emqKeeper.getMqttClient().subscribe(airportTopic, 1, amosMqttListener);
        } catch (MqttException e) {
            e.printStackTrace();
            logger.error("EMQ初始化连接失败!");
        }
    }

}