package com.yeejoin.amos.knowledgebase.face.service;


import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsValueModel;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagInstanceModel;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagModel;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagValueModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.TagInstanceMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeTagInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;


/**
 * <p>
 * 标签实例 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class TagInstanceService extends BaseService<KnowledgeTagInstanceModel, KnowledgeTagInstance, TagInstanceMapper> {


    public static final String MARKING_TYPE_DOC = "DOC";  // 标记类型--文档标签
    public static final String MARKING_TYPE_CONTENT = "CONTENT";// 标记类型--内容标签

    @Autowired
    private TagValueService tagValueService;

    @Autowired
    private TagService tagService;

    @Autowired
    private Sequence sequence;

    @Autowired
    private DynamicsValueService dynamicsValueService;

    /**
     * @return java.util.List<com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagInstanceModel>
     * @author 杨博超
     * @description 保存标签实例
     * @Param [tagInstance]
     **/
    public List<KnowledgeTagInstanceModel> saveInstance(List<KnowledgeTagInstanceModel> tagInstanceList, Long targetSeq, String markingType) {


        List<KnowledgeTagInstanceModel> savedInstances = new ArrayList<>();

        if (!ValidationUtil.isEmpty(tagInstanceList)) {
            for (KnowledgeTagInstanceModel instanceModel : tagInstanceList) {
                KnowledgeTagModel tagModel = this.tagService.queryBySeq(instanceModel.getTagSeq());

                Long instanceSeq = sequence.nextId();
                instanceModel.setSequenceNbr(instanceSeq);
                instanceModel.setAgencyCode(RequestContext.getAgencyCode());
                instanceModel.setMarkingType(markingType);
                instanceModel.setTargetSeq(targetSeq);
                instanceModel.setTagName(tagModel.getTagName());
                instanceModel.setTagType(tagModel.getTagType());
                //值标签保存标签的具体值
                List<KnowledgeTagValueModel> valueModels = instanceModel.getTagValues();
                if (TagService.TAG_TYPE_VALUE.equals(tagModel.getTagType()) && !ValidationUtil.isEmpty(valueModels)) {
                    List<KnowledgeDynamicsValueModel> valueTagConfigs = dynamicsValueService.queryByInstanceId(tagModel.getSequenceNbr());
                    Map<String, Object> valueTagConfigMap = Bean.listToMap(valueTagConfigs, "fieldName", "fieldValue", KnowledgeDynamicsValueModel.class);
                    String unit = String.valueOf(valueTagConfigMap.get("unit"));
                    List<KnowledgeTagValueModel> savedValues = this.tagValueService.saveInstanceValue(instanceSeq, valueModels, unit);
                    instanceModel.setTagValues(savedValues);
                }
                this.createWithModel(instanceModel);
                savedInstances.add(instanceModel);
            }
        }

        return savedInstances;
    }


    public void deleteByTargetSeq(Long targetSeq) {

        List<KnowledgeTagInstanceModel> list = this.queryForList("", false, targetSeq);
        if (!ValidationUtil.isEmpty(list)) {
            for (KnowledgeTagInstanceModel model : list) {
                tagValueService.deleteByInstanceId(model.getSequenceNbr());
                this.deleteBySeq(model.getSequenceNbr());
            }
        }
    }


//    /**
//     * 根据标签ID和目标ID列表统计标签实例数量
//     *
//     * @param tagSeq     标签ID
//     * @param targetSeq  目标ID列表
//     * @return 数量
//     */
//    public int countByTagSeqAndTargetSeqs(Long tagSeq, @Condition(Operator.in) Collection<Long> targetSeq) {
//        return this.queryCount(tagSeq, targetSeq);
//    }

    /**
     * 根据标签ID统计标签实例数量
     */
    public int queryCountByTagSeq(Long tagSeq) {
        return this.queryCount(tagSeq);
    }

//    /** 根据标签ID和文档id列表查询标签实例列表 */
//    public List<KnowledgeTagInstanceModel> queryListByTagSeq(Long tagSeq, @Condition(Operator.in) Collection<Long> targetSeq) {
//        return this.queryForList("", false, tagSeq, targetSeq);
//    }

//    //TODO 使用统计方法 this.queryCount
//    public Map<Long, Integer> countByTagSeqWithTargetSeq(Long targetSeq) {
//        Map<Long, Integer> resMap = new HashMap<>();
//        List<KnowledgeTagInstanceModel> instanceModelList = queryListByTargetSeq(targetSeq);
//        for (KnowledgeTagInstanceModel instanceModel : instanceModelList) {
//            Long tagSeq = instanceModel.getTagSeq();
//            Integer count = resMap.containsKey(tagSeq) ? resMap.get(tagSeq) + 1 : 1;
//            resMap.put(tagSeq, count);
//        }
//        return resMap;
//    }


    public List<KnowledgeTagInstanceModel> queryByTargetAndType(String agencyCode, Long targetSeq, String markingType) {

        List<KnowledgeTagInstanceModel> instanceModels = this.queryForList(null, false, agencyCode, targetSeq, markingType);
        if (!ValidationUtil.isEmpty(instanceModels)) {
            for (KnowledgeTagInstanceModel instanceModel : instanceModels) {
                if (TagService.TAG_TYPE_VALUE.equals(instanceModel.getTagType())) {
                    List<KnowledgeTagValueModel> list = this.tagValueService.queryByInstance(instanceModel.getSequenceNbr());
                    instanceModel.setTagValues(list);
                }
            }
        }
        return instanceModels;
    }

    public List<KnowledgeTagInstanceModel> queryListByTargetSeq(Long targetSeq) {
        return this.queryForList(null, false, targetSeq);
    }

    public List<KnowledgeTagInstanceModel> queryListByTargetSeqs(@Condition(Operator.in) Collection<Long> targetSeq) {
        return this.queryForList(null, false, targetSeq);
    }

    public List<KnowledgeTagInstanceModel> queryTopTagListByUser(String recUserId) {
        return this.queryForList("REC_DATE", true, recUserId);
    }
}
