package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.config.DealerRestrict;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.DropDown;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 第三方场站 Mapper 接口
 *
 * @author system_generator
 * @date 2023-09-19
 */
public interface JpStationMapper extends BaseMapper<JpStation> {
    List<JpStationDto> queryForDealerReviewPage(@Param("dto") JpStationDto reviewDto);
    JpStationDto queryCount(@Param("dto") JpStationDto reviewDto);
    List<Map<String,Object>>  countState(@Param("dto") JpStationDto reviewDto);
    List<Map<String,Double>> getPowerqx(String dateType);

    //@DealerRestrict(field ={"amos_company_code","regional_companies_code","developer_user_id"} ,fieldConditions ={"in","in","in"} ,relationship="and")
    @UserEmpower(field ={"hygf_jp_station.regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    List<JpStation> getJpStation(@Param("dto") JpStationDto reviewDto);

    List<JpStation> getJpStationList(@Param("dto") JpStationDto reviewDto);

    @UserEmpower(field ={"ORG_CODE"} ,dealerField ={"ORG_CODE"}, fieldConditions ={"in","in","in"} ,relationship="and",specific=false)
    List<DropDown>  getRegion();

    @UserEmpower(field ={"hygf_regional_companies.regional_companies_code"} ,dealerField ={"hygf_unit_info.amos_company_code","hygf_regional_companies.regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    List<DropDown>  getDealer(@Param("regionalCompaniesCode") String regionalCompaniesCode);

    @UserEmpower(field ={"regional_companies_code"} ,dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    JpStationDto getCountJpStationdata(@Param("dto") JpStationDto reviewDto);

    @UserEmpower(field ={"regional_companies_code"} ,dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    List<Map<String,Object>>  getcountState(@Param("dto") JpStationDto reviewDto);
    //投产电站数
    @UserEmpower(field ={"regional_companies_code"} ,dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    Map<String,Object>getcountStatetc(@Param("dto") JpStationDto reviewDto);
    //建设建站数
    @UserEmpower(field ={"regional_companies_code"} ,dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    Map<String,Object>getcountStatejs(@Param("dto") JpStationDto reviewDto);
    //接入中电站数
    @UserEmpower(field ={"regional_companies_code"} ,dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    Map<String,Object>getcountStatejr(@Param("dto") JpStationDto reviewDto);

    @UserEmpower(field ={"regional_companies_code"} ,dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
    Map<String,Object> getcount( @Param("dto") JpStationDto reviewDto);

    @UserEmpower(field ={"hygf_jp_station.regional_companies_code"},dealerField ={"hygf_jp_station.amos_company_code","hygf_jp_station.regional_companies_code"} ,fieldConditions ={"in","in"} ,relationship="and")
   List<JpStationDto> queryForDealerReviewPagenew(@Param("dto") JpStationDto reviewDto, Page<JpStationDto> pa);

    List<DropDown>  getDealerNew(@Param("regionalCompaniesSeq") String regionalCompaniesSeq);
}
