package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.config.DealerRestrict;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.DropDown;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.mapper.*;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.DayGenerateServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpStationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 第三方场站
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "第三方场站Api")
@RequestMapping(value = "/jp-station")
public class JpStationController extends BaseController {

    private static Double CARBON = 0.997 * 0.001;
    private static Double SULFUR = 0.03 * 0.001;
    private static Double DUST = 0.272 * 0.001;
    private static Double COAL = 0.4 * 0.001;
    private static String ZX = "在线";
    private static String LX = "离线";
    private static String BJ = "报警";
    private static int FDXSS = 1000;
    @Autowired
    JpStationServiceImpl jpStationServiceImpl;
    @Autowired
    JpPersonStationMapper pPersonStationMapper;
    @Autowired
    JpStationMapper jpStationMapper;
    @Autowired
    JpCollectorMapper jpCollectorMapper;
    @Autowired
    JpInverterMapper jpInverterMapper;
    @Autowired
    DayGenerateServiceImpl dayGenerateServiceImpl;
    @Autowired
    RegionalCompaniesMapper regionalCompaniesMapper;

    /**
     * 新增第三方场站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增第三方场站", notes = "新增第三方场站")
    public ResponseModel<JpStationDto> save(@RequestBody JpStationDto model) {
        model = jpStationServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新第三方场站", notes = "根据sequenceNbr更新第三方场站")
    public ResponseModel<JpStationDto> updateBySequenceNbrJpStation(@RequestBody JpStationDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jpStationServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除第三方场站", notes = "根据sequenceNbr删除第三方场站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jpStationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getBysequenceNbr")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个第三方场站", notes = "根据sequenceNbr查询单个第三方场站")
    public ResponseModel<JpStationDto> selectOne(String id) {
        Long sequenceNbr = Long.valueOf(id);
        JpStationDto jpStationDto = jpStationServiceImpl.queryBySeq(sequenceNbr);
        LambdaQueryWrapper<JpInverter> qug = new LambdaQueryWrapper<>();
        qug.eq(JpInverter::getThirdStationId, jpStationDto.getThirdStationId());
        List<JpInverter> jpInverter = jpInverterMapper.selectList(qug);
        LambdaQueryWrapper<JpCollector> qug1 = new LambdaQueryWrapper<>();
        qug1.eq(JpCollector::getThirdStationId, jpStationDto.getThirdStationId());
        List<JpCollector> jpCollector = jpCollectorMapper.selectList(qug1);
        jpStationDto.setJpCollector(jpCollector);
        jpStationDto.setJpInverter(jpInverter);
//        //区域公司
//        LambdaQueryWrapper<RegionalCompanies> qug2=new LambdaQueryWrapper<>();
//        qug2.eq(RegionalCompanies::getRegionalCompaniesCode,jpStationDto.getRegionalCompaniesCode());
//        qug2.last("LIMIT 1");
//        RegionalCompanies  personnelBusiness= regionalCompaniesMapper.selectOne(qug2);
//        String names = jpCollector.stream().map(JpCollector::getSnCode).collect(Collectors.joining(","));
//        String name = jpInverter.stream().map(JpInverter::getSnCode).collect(Collectors.joining(","));
//        jpStationDto.setNBSN(name);
//        jpStationDto.setCJSN(names);
//        jpStationDto.setRegionalCompaniesName(personnelBusiness.getRegionalCompaniesName());
        return ResponseHelper.buildResponse(jpStationDto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getBysequenceNbrnew")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个第三方场站", notes = "根据sequenceNbr查询单个第三方场站")
    public ResponseModel<JpStationDto> selectOneThirdStationId(String id) {


        LambdaQueryWrapper<JpStation> qug3 = new LambdaQueryWrapper<>();
        qug3.eq(JpStation::getThirdStationId, id);
        JpStation JpStation = jpStationMapper.selectOne(qug3);

        JpStationDto jpStationDto = jpStationServiceImpl.queryBySeq(JpStation.getSequenceNbr());
        LambdaQueryWrapper<JpInverter> qug = new LambdaQueryWrapper<>();
        qug.eq(JpInverter::getThirdStationId, jpStationDto.getThirdStationId());
        List<JpInverter> jpInverter = jpInverterMapper.selectList(qug);
        LambdaQueryWrapper<JpCollector> qug1 = new LambdaQueryWrapper<>();
        qug1.eq(JpCollector::getThirdStationId, jpStationDto.getThirdStationId());
        List<JpCollector> jpCollector = jpCollectorMapper.selectList(qug1);
        jpStationDto.setJpCollector(jpCollector);
        jpStationDto.setJpInverter(jpInverter);
        //区域公司
        LambdaQueryWrapper<RegionalCompanies> qug2 = new LambdaQueryWrapper<>();
        qug2.eq(RegionalCompanies::getRegionalCompaniesCode, jpStationDto.getRegionalCompaniesCode());
        qug2.last("LIMIT 1");
        RegionalCompanies personnelBusiness = regionalCompaniesMapper.selectOne(qug2);
        String names = jpCollector.stream().map(JpCollector::getSnCode).collect(Collectors.joining(","));
        String name = jpInverter.stream().map(JpInverter::getSnCode).collect(Collectors.joining(","));
        jpStationDto.setNbsn(name);
        jpStationDto.setCjsn(names);
        jpStationDto.setCapacity(jpStationDto.getCapacity());
        jpStationDto.setRegionalCompaniesName(personnelBusiness.getRegionalCompaniesName());
        return ResponseHelper.buildResponse(jpStationDto);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryPage")
    @ApiOperation(httpMethod = "GET", value = "场站列表", notes = "场站列表")
    public ResponseModel<Page<JpStationDto>> queryForDealerReviewPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, JpStationDto reviewDto) {

        List<JpPersonStation> pPersonStation = null;
        if (reviewDto.getName() != null && !"".equals(reviewDto.getName())) {
            LambdaQueryWrapper<JpPersonStation> qug1 = new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName, reviewDto.getName());
            pPersonStation = pPersonStationMapper.selectList(qug1);
        } else {
            //获取当前人管理场站
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
            pPersonStation = pPersonStationMapper.selectList(qug);
        }


//        if(reviewDto.getThirdStationId()==null){

        if (pPersonStation != null && !pPersonStation.isEmpty()) {
            reviewDto.setStatioId(pPersonStation.isEmpty() ? null : pPersonStation);
        } else {
            return ResponseHelper.buildResponse(null);
        }
//        }
        Page<JpStationDto> page = jpStationServiceImpl.queryForJpStationPage(current, size, reviewDto);
        return ResponseHelper.buildResponse(page);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/countState")
    @ApiOperation(httpMethod = "GET", value = "场站列表", notes = "场站列表")
    public ResponseModel<Map<String, Object>> countState(JpStationDto reviewDto) {

        Set<String> se = new HashSet<>();
        List<JpPersonStation> pPersonStation = null;
        if (reviewDto.getName() != null && !"".equals(reviewDto.getName())) {
            LambdaQueryWrapper<JpPersonStation> qug1 = new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName, reviewDto.getName());
            pPersonStation = pPersonStationMapper.selectList(qug1);
        } else {
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
            pPersonStation = pPersonStationMapper.selectList(qug);
        }
        reviewDto.setStatioId(pPersonStation.isEmpty() ? null : pPersonStation);
        List<Map<String, Object>> list = jpStationMapper.countState(reviewDto);
        Map<String, Object> collector = new HashMap<>();
        collector.put("zx", 0);
        collector.put("bj", 0);
        collector.put("lx", 0);
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> map : list) {
                if ("在线".equals(map.get("state").toString())) {
                    collector.put("zx", Integer.valueOf(map.get("num").toString()));
                } else if ("离线".equals(map.get("state").toString())) {
                    collector.put("lx", Integer.valueOf(map.get("num").toString()));
                } else if ("报警".equals(map.get("state").toString())) {
                    collector.put("bj", Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        return ResponseHelper.buildResponse(collector);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getpStation")
    @ApiOperation(httpMethod = "GET", value = "设备监控", notes = "设备监控")
    public ResponseModel<Map<String, Object>> getpStation(JpStationDto reviewDto) {

        List<JpPersonStation> pPersonStation = null;
        if (reviewDto.getName() != null && !"".equals(reviewDto.getName())) {
            LambdaQueryWrapper<JpPersonStation> qug1 = new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName, reviewDto.getName());
            pPersonStation = pPersonStationMapper.selectList(qug1);
        } else {
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
            pPersonStation = pPersonStationMapper.selectList(qug);
        }


        if (pPersonStation != null && !pPersonStation.isEmpty()) {
            reviewDto.setStatioId(pPersonStation.isEmpty() ? null : pPersonStation);
        } else {
            return ResponseHelper.buildResponse(null);
        }
        List<Map<String, Object>> listCollector = jpCollectorMapper.queryCollectorCountStatus(reviewDto);
        List<Map<String, Object>> listInverter = jpInverterMapper.queryInverterCountStatus(reviewDto);
        Map<String, Object> collector = new HashMap<>();
        collector.put("zx", 0);
        collector.put("gj", 0);
        collector.put("lx", 0);
        Map<String, Object> inverter = new HashMap<>();
        inverter.put("zx", 0);
        inverter.put("gj", 0);
        inverter.put("lx", 0);
        if (!listCollector.isEmpty()) {
            for (Map<String, Object> map : listCollector) {
                if ("在线".equals(map.get("state").toString())) {
                    collector.put("zx", Integer.valueOf(map.get("num").toString()));
                } else if ("离线".equals(map.get("state").toString())) {
                    collector.put("lx", Integer.valueOf(map.get("num").toString()));
                } else if ("报警".equals(map.get("state").toString())) {
                    collector.put("gj", Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        if (!listInverter.isEmpty()) {
            for (Map<String, Object> map : listInverter) {
                if ("在线".equals(map.get("state").toString())) {
                    inverter.put("zx", Integer.valueOf(map.get("num").toString()));
                } else if ("离线".equals(map.get("state").toString())) {
                    inverter.put("lx", Integer.valueOf(map.get("num").toString()));
                } else if ("报警".equals(map.get("state").toString())) {
                    inverter.put("gj", Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        Map<String, Object> map = new HashMap<>();
        map.put("collector", collector);
        map.put("inverter", inverter);
        return ResponseHelper.buildResponse(map);

    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryListcz")
    @ApiOperation(httpMethod = "GET", value = "登陆人管理场站列表", notes = "登陆人管理场站列表")
    public ResponseModel<List<JpPersonStation>> queryList() {
        //获取当前人管理场站
        LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
        qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
        List<JpPersonStation> pPersonStation = pPersonStationMapper.selectList(qug);
        return ResponseHelper.buildResponse(pPersonStation);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryUserListyz")
    @ApiOperation(httpMethod = "GET", value = "登陆人管理场站业主列表", notes = "登陆人管理场站业主列表")
    public ResponseModel<List<String>> queryUserList() {
        //获取当前人管理场站
        LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
        qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
        List<JpPersonStation> pPersonStation = pPersonStationMapper.selectList(qug);
        List data = new ArrayList();
        if (pPersonStation != null && !pPersonStation.isEmpty()) {
            for (JpPersonStation jpPersonStation : pPersonStation) {
                data.add(jpPersonStation.getOwner());
            }
        }
        return ResponseHelper.buildResponse(data);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "电站监控电量收益", notes = "电站监控电量收益")
    @GetMapping(value = "/getIncomePower")
    public ResponseModel<JpStationDto> getIncomePower(JpStationDto reviewDto) {
        //获取当前人管理场站
        if (reviewDto.getThirdStationId() == null) {
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation = pPersonStationMapper.selectList(qug);
            if (pPersonStation != null && !pPersonStation.isEmpty()) {
                reviewDto.setStatioId(pPersonStation.isEmpty() ? null : pPersonStation);
            } else {
                return ResponseHelper.buildResponse(null);
            }
        }
        return ResponseHelper.buildResponse(jpStationMapper.queryCount(reviewDto));
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "工率曲线", notes = "电站监控电量收益")
    @GetMapping(value = "/getPowerqx")
    public ResponseModel<Map<String, List<Object>>> getPowerqx(JpStationDto reviewDto, String date, String type) {
        //获取当前人管理场站
        List<String> data = new ArrayList();
        Set<String> se = new HashSet<>();
        if (reviewDto.getName() != null) {
            LambdaQueryWrapper<JpPersonStation> qug1 = new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName, reviewDto.getName());
            List<JpPersonStation> pPersonStation1 = pPersonStationMapper.selectList(qug1);
            if (pPersonStation1 != null && !pPersonStation1.isEmpty()) {
                for (JpPersonStation jpPersonStation : pPersonStation1) {
                    se.add(jpPersonStation.getStationId());
                }
            }
            data.addAll(se);
        } else {
            if (reviewDto.getThirdStationId() == null) {
                //获取当前人管理场站
                LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
                qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
                List<JpPersonStation> pPersonStation = pPersonStationMapper.selectList(qug);
                if (pPersonStation != null && !pPersonStation.isEmpty()) {

                    for (JpPersonStation jpPersonStation : pPersonStation) {
                        data.add(jpPersonStation.getStationId());
                    }
                } else {
                    return ResponseHelper.buildResponse(null);
                }
            } else {
                data.add(reviewDto.getThirdStationId());
            }
        }

        return ResponseHelper.buildResponse(jpStationServiceImpl.getPowerqx(date, type, data));
    }


    //查询当前登录人权限区域公司
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询当前登录人权限区域公司", notes = "查询当前登录人权限区域公司")
    @GetMapping(value = "/getRegion")
    @UserLimits
    public ResponseModel<List<Map<String, String>>> getRegion() {

        List<DropDown> list = jpStationMapper.getRegion();
        List<Map<String, String>> result = new ArrayList<>();
        list.forEach(dropDown -> {
            Map<String, String> item = new HashMap<>();
            item.put("text", dropDown.getName());
            item.put("value", dropDown.getOrgCode());
            result.add(item);
        });

        return ResponseHelper.buildResponse(result);
    }


    //查询当前登录人权限经销商
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询当前登录人权限经销商", notes = "查询当前登录人权限经销商")
    @GetMapping(value = "/getDealer")
    @UserLimits
    public ResponseModel<List<Map<String, String>>> getDealer(String regionalCompaniesCode) {
        List<DropDown> list = jpStationMapper.getDealer(regionalCompaniesCode);
        List<Map<String, String>> result = new ArrayList<>();
        list.forEach(dropDown -> {
            Map<String, String> item = new HashMap<>();
            item.put("text", dropDown.getName());
            item.put("value", dropDown.getOrgCode());
            result.add(item);
        });
        return ResponseHelper.buildResponse(result);
    }

    //电站发电量统计

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "电站发电量统计", notes = "电站发电量统计")
    @GetMapping(value = "/getCountJpStationdata")
    @UserLimits
    public ResponseModel<Page<JpStationDto>> getCountJpStationdata(JpStationDto reviewDto) {
        JpStationDto jpStation = jpStationMapper.getCountJpStationdata(reviewDto);
        List<Map<String, Object>> powerRatio = new ArrayList<>();
        Map<String, Object> map = new HashMap<>();
        if (jpStation != null && jpStation.getRealTimePower() != null && jpStation.getRatedPower() != null && jpStation.getRatedPower() > 0) {
            map.put("value", String.format("%.4f", jpStation.getRealTimePower() / (jpStation.getCapacity() * FDXSS)));
        } else {
            jpStation = new JpStationDto();
            map.put("value", 0);
        }
        powerRatio.add(map);
        jpStation.setPowerRatio(powerRatio);
        List<JpStationDto> list = new ArrayList<>();
        list.add(jpStation);
        Page<JpStationDto> result = new Page<>();
        result.setCurrent(1);
        result.setTotal(1);
        result.setRecords(list);
        return ResponseHelper.buildResponse(result);
    }

    //电站分布
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "电站分布", notes = "电站分布")
    @GetMapping(value = "/getJpStation")
    @UserLimits
    public Object getJpStation(JpStationDto reviewDto) {
        List<JpStation> list = jpStationMapper.getJpStation(reviewDto);
        return ResponseHelper.buildResponse(list);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "电站场站无权限", notes = "电站场站无权限")
    @GetMapping(value = "/getJpStationList")
    public ResponseModel<List<JpStation>> getJpStationList(JpStationDto reviewDto) {

        return ResponseHelper.buildResponse(jpStationServiceImpl.getJpStationList(reviewDto));
    }

    //节能减排

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "节能减排", notes = "节能减排")
    @GetMapping(value = "/getEnergyConservation")
    @UserLimits
    public ResponseModel<Page<Map<String, Object>>> getEnergyConservation(JpStationDto reviewDto) {
        Page<Map<String, Object>> result = new Page<>();
        List<Map<String, Object>> itemList = new ArrayList<>();
        JpStationDto jpStation = jpStationMapper.getCountJpStationdata(reviewDto);
        Map<String, Object> map = new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("0.00");
        //炭
        map.put("carbon", format2.format(jpStation.getAccumulatedPower() * FDXSS * CARBON));
        //硫
        map.put("sulfur", format2.format(jpStation.getAccumulatedPower() * FDXSS * SULFUR));
        //粉尘
        map.put("dust", format2.format(jpStation.getAccumulatedPower() * FDXSS * DUST));
        //煤
        map.put("coal", format2.format(jpStation.getAccumulatedPower() * FDXSS * COAL));
        itemList.add(map);
        result.setCurrent(1);
        result.setTotal(1);
        result.setRecords(itemList);
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "电站列表统计", notes = "电站列表统计")
    @GetMapping(value = "/getjpStationConservation")
    @UserLimits
    public ResponseModel<Page<Map<String, Object>>> getjpStationConservation(JpStationDto reviewDto) {
        JpStationDto jpStation = jpStationMapper.getCountJpStationdata(reviewDto);
        List<Map<String, Object>> date = new ArrayList<>();
        Map<String, Object> map = new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("0.000");
        //炭
        map.put("name1", "实时功率(kW)");
        map.put("name2", "组件总容量(MWp)");

        map.put("value1", jpStation.getRealTimePower()!=null?format2.format(jpStation.getRealTimePower()):0);
        //硫
        map.put("value2", jpStation.getCapacity()!=null?format2.format(jpStation.getCapacity()):0);

        Map<String, Object> map2 = new HashMap<>();
        map2.put("name1", "当日电量(MWh)");
        map2.put("name2", "当日收益(元)");
        //炭
        map2.put("value1", jpStation.getDayGenerate()!=null?format2.format(jpStation.getDayGenerate()):0);
        //硫
        map2.put("value2", jpStation.getDayIncome()!=null?format2.format(jpStation.getDayIncome()):0);
        Map<String, Object> map3 = new HashMap<>();
        map3.put("name1", "当月电量(MWh)");
        map3.put("name2", "当月收益(万元)");
        //炭
        map3.put("value1", jpStation.getMonthGenerate()!=null?format2.format(jpStation.getMonthGenerate()):0);
        //硫
        map3.put("value2", jpStation.getMonthIncome()!=null?format2.format(jpStation.getMonthIncome()):0);
        Map<String, Object> map4 = new HashMap<>();
        map4.put("name1", "累计电量(MWh)");
        map4.put("name2", "累计收益(万元)");
        //炭
        map4.put("value1", jpStation.getAccumulatedPower()!=null?format2.format(jpStation.getAccumulatedPower()):0);
        //硫
        map4.put("value2", jpStation.getCumulativeIncome()!=null?format2.format(jpStation.getCumulativeIncome()):0);

        date.add(map);
        date.add(map2);
        date.add(map3);
        date.add(map4);
        Page<Map<String, Object>> page = new Page<>(1, 4);
        page.setRecords(date);
        return ResponseHelper.buildResponse(page);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "电站统计", notes = "电站统计")
    @GetMapping(value = "/getcountJpStationNum")
    public ResponseModel<List<Map<String, Object>>> getcountJpStationNum(JpStationDto reviewDto) {
        List<Map<String, Object>> itemList = new ArrayList<>();
        Map<String, Object> collector = new HashMap<>();
        collector.put("在线", 0);
        collector.put("离线", 0);
        collector.put("报警", 0);
        List<Map<String, Object>> list = jpStationServiceImpl.getcountState(reviewDto);
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> map : list) {
                if (ZX.equals(map.get("state").toString())) {

                    collector.put("正常", Integer.valueOf(map.get("num").toString()));
                } else if (LX.equals(map.get("state").toString())) {
                    collector.put("离线", Integer.valueOf(map.get("num").toString()));
                } else if (BJ.equals(map.get("state").toString())) {
                    collector.put("报警", Integer.valueOf(map.get("num").toString()));
                }
            }
        }

        Map<String, Object> result = new HashMap<>();
        result.put("name", "正常");
        result.put("value", collector.get("正常"));
        itemList.add(result);

        Map<String, Object> result1 = new HashMap<>();
        result1.put("name", "离线");
        result1.put("value", collector.get("离线"));
        itemList.add(result1);

        Map<String, Object> result2 = new HashMap<>();
        result2.put("name", "报警");
        result2.put("value", collector.get("报警"));
        itemList.add(result2);

        return ResponseHelper.buildResponse(itemList);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "电站统计", notes = "电站统计")
    @GetMapping(value = "/getcountJpStation")
    public ResponseModel<Page<Map<String, Object>>> getcountJpStation(JpStationDto reviewDto) {
        List<Map<String, Object>> itemList = new ArrayList<>();
        Map<String, Object> collector = new HashMap<>();
        collector.put("zx", 0);
        collector.put("bj", 0);
        collector.put("lx", 0);
        List<Map<String, Object>> list = jpStationServiceImpl.getcountState(reviewDto);
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> map : list) {
                if (ZX.equals(map.get("state").toString())) {
                    collector.put("zx", Integer.valueOf(map.get("num").toString()));
                } else if (LX.equals(map.get("state").toString())) {
                    collector.put("lx", Integer.valueOf(map.get("num").toString()));
                } else if (BJ.equals(map.get("state").toString())) {
                    collector.put("bj", Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        Map<String, Object> js = jpStationServiceImpl.getcountStatejs(reviewDto);
        Map<String, Object> tc = jpStationServiceImpl.getcountStatetc(reviewDto);
        Map<String, Object> jr = jpStationServiceImpl.getcountStatejr(reviewDto);
        Map<String, Object> zs = jpStationServiceImpl.getcount(reviewDto);

        collector.put("js", js.get("num"));
        collector.put("tc", tc.get("num"));
        collector.put("jr", jr.get("num"));
        collector.put("zs", zs.get("num"));
        itemList.add(collector);
        Page<Map<String, Object>> result = new Page<>();
        result.setCurrent(1);
        result.setTotal(1);
        result.setRecords(itemList);
        return ResponseHelper.buildResponse(result);
    }

    //日满发小时排行

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "日满发小时排行", notes = "日满发小时排行")
    @GetMapping(value = "/getDayGenerateph")
    public ResponseModel<Page<Map<String, Object>>> getDayGenerateph(JpStationDto reviewDto, String type, String dateTime) {

        List<JpStation> list = jpStationServiceImpl.getJpStation(reviewDto);
        List<Map<String, Object>> li = new ArrayList<>();
        List<DayGenerate> date = dayGenerateServiceImpl.getDayGenerateph(list, type, dateTime);
        DecimalFormat format2 = new DecimalFormat("0.00");
        if (date != null && !list.isEmpty()) {
            for (DayGenerate dayGenerate : date) {
                Map<String, Object> map = new HashMap<>();
                for (JpStation jpStation : list) {
                    if (dayGenerate.getThirdStationId().equals(jpStation.getThirdStationId())) {
                        map.put("id", jpStation.getSequenceNbr());
                        map.put("name", jpStation.getName());
                        map.put("address", jpStation.getAddress());
                        map.put("fullhour", format2.format(dayGenerate.getFullhour()));
                        li.add(map);
                        break;
                    }
                }

            }
        }
        Page<Map<String, Object>> result = new Page<>();
        result.setCurrent(1);
        result.setTotal(10);
        result.setRecords(li);
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "发电量曲线", notes = "发电量曲线")
    @GetMapping(value = "/getGenerateqx")
    public ResponseModel<Map<String, List<Object>>> getGenerateqx(JpStationDto reviewDto, String date, String type) {

        Map<String, List<Object>> map = jpStationServiceImpl.getGenerateqx(date, type, reviewDto);


        return ResponseHelper.buildResponse(map);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "工率曲线", notes = "电站监控电量收益")
    @GetMapping(value = "/getPowerqxnew")
    public ResponseModel<Map<String, List<Object>>> getPowerqxnew(JpStationDto reviewDto, String date) {

        Map<String, List<Object>> map = jpStationServiceImpl.getPowerqxnew(date, reviewDto);

        return ResponseHelper.buildResponse(map);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryPagenew")
    @ApiOperation(httpMethod = "GET", value = "场站列表", notes = "场站列表")
    @UserLimits
    public ResponseModel<Page<JpStationDto>> queryPagenew(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, JpStationDto reviewDto) {
        Page<JpStationDto> page = jpStationServiceImpl.queryForJpStationPagenew(current, size, reviewDto);
        return ResponseHelper.buildResponse(page);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/queryReport")
    @ApiOperation(httpMethod = "POST", value = "场站报表", notes = "场站报表")
    public ResponseModel<Page<JpStationDto>> queryReport(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, @RequestBody JpStationDto reviewDto, @RequestParam(value = "type") String type) {

        Page<JpStationDto> page = jpStationServiceImpl.queryReport(current, size, reviewDto, type);

        return ResponseHelper.buildResponse(page);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "登录人场站", notes = "登录人场站")
    @GetMapping(value = "/getuserJpStation")
    public ResponseModel<List<JpStation>> getuserJpStation(JpStationDto reviewDto) {
        List<JpStation> list = jpStationServiceImpl.getJpStation(reviewDto);
        return ResponseHelper.buildResponse(list);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "工率曲线", notes = "电站监控电量收益")
    @GetMapping(value = "/test")
    public Object getPowerqx(JpStationDto reviewDto) {

        List<JpStation> list = jpStationServiceImpl.getJpStation(new JpStationDto());
        return list;
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/jpstationReportExport", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "电站报表导出", notes = "电站报表导出")
    public void jpstationReportExport(HttpServletResponse response, @RequestBody JpStationDto reviewDto, @RequestParam(value = "type") String type) {
//        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());

        List<JpStationDto> jpStationDtos = jpStationServiceImpl.selectReportDate(reviewDto, type, response);
//        try {
//            setResponseHeadForDowload(response,"电站报表.xls");
//            EasyExcel.write(response.getOutputStream()).head(JpStationDto.class).excelType(ExcelTypeEnum.XLS).sheet("电站报表")
//
//                    .doWrite(jpStationDtos);
//        } catch (IOException e) {
//            throw new RuntimeException(e);
//        }
    }


}
