package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.*;
import com.yeejoin.amos.boot.module.hygf.api.entity.ConstructionRecords;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.entity.PowerStationConstructionData;
import com.yeejoin.amos.boot.module.hygf.api.entity.WorkOrder;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PersonnelBusinessMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PowerStationConstructionDataMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.WorkOrderMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.WorkOrderPowerStationMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.WorkOrderServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工派工工单
 *
 * @author system_generator
 * @date 2024-01-02
 */
@RestController
@Api(tags = "施工派工工单Api")
@RequestMapping(value = "/work-order")
public class WorkOrderController extends BaseController {

    @Autowired
    WorkOrderServiceImpl workOrderServiceImpl;
    @Autowired
    WorkOrderPowerStationMapper workOrderPowerStationMapper;
    @Autowired
    WorkOrderMapper workOrderMapper;

    @Autowired
    PersonnelBusinessMapper personnelBusinessMapper;
    @Autowired
    PowerStationConstructionDataMapper powerStationConstructionDataMapper;
    /**
     * 新增施工派工工单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增施工派工工单", notes = "新增施工派工工单")
	public ResponseModel<WorkOrder> save(@RequestBody WorkOrder model) {
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());
	    model = workOrderServiceImpl.saveWorkOrder(model,userUnitInformationDto);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新施工派工工单", notes = "根据sequenceNbr更新施工派工工单")
	public ResponseModel<WorkOrder> updateBySequenceNbrWorkOrder(@RequestBody WorkOrder model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());
	    return ResponseHelper.buildResponse(workOrderServiceImpl.updateWorkOrder(model,userUnitInformationDto));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除施工派工工单", notes = "根据sequenceNbr删除施工派工工单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(workOrderServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工派工工单",  notes = "根据sequenceNbr查询单个施工派工工单")
	public ResponseModel<WorkOrder> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(workOrderServiceImpl.selectOne(sequenceNbr));
	}

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectOneall")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工派工工单",  notes = "根据sequenceNbr查询单个施工派工工单")
    public ResponseModel<Map<String,Object>> selectOneall(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(workOrderServiceImpl.selectOneall(sequenceNbr));
    }



	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping   (value = "/page")
	@ApiOperation(httpMethod = "GET",value = "施工派工工单分页查询",  notes = "施工派工工单分页查询")
    @UserLimits
	public ResponseModel<Page<WorkOrder>> queryForPage(@RequestBody WorkOrder  workOrder
    ) {

//        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());
//
//        workOrder.setRegionCompanyId(userUnitInformationDto.getRegionalCompaniesSeq());
//        workOrder.setAmosDealerId(userUnitInformationDto.getAmosDealerId());

        return ResponseHelper.buildResponse(workOrderServiceImpl.selectPage(workOrder.getCurrent(),workOrder.getSize(), workOrder));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "施工派工工单列表全部数据查询",   notes = "施工派工工单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<WorkOrderDto>> selectForList() {
	    return ResponseHelper.buildResponse(workOrderServiceImpl.queryForWorkOrderList());
	}



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
    @GetMapping(value = "/getWorkOrderHousehold")
    public ResponseModel<  Page<PeasantHousehold>  > getPeasantHouseholdData(
            @RequestParam(required=false) Long sequenceNbr,
            @RequestParam(required=false) String ownersName
    ) {
        List<PeasantHousehold> list=workOrderPowerStationMapper.selectPeasantHousehold(sequenceNbr,ownersName);

        Page<PeasantHousehold> pagenew = new Page<PeasantHousehold>();
        pagenew.setRecords(list);
        pagenew.setTotal(list.size());
        return ResponseHelper.buildResponse(pagenew);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/wgpage")
    @ApiOperation(httpMethod = "GET",value = "施工派工工单分页查询",  notes = "施工派工工单分页查询")
    @UserLimits
    public ResponseModel<Page<WorkOrderPage>> queryForwgpage(
                                                         @RequestBody WorkOrderPage  workOrder
    ) {

	     //当前登录人所属场站
//        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());
//
//        workOrder.setRegionCompanyId(userUnitInformationDto.getRegionalCompaniesSeq());
//        workOrder.setAmosDealerId(userUnitInformationDto.getAmosDealerId());

        return ResponseHelper.buildResponse(workOrderServiceImpl.queryForwgpage(workOrder.getCurrent(),workOrder.getSize(), workOrder));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/wgpageList")
    @ApiOperation(httpMethod = "GET",value = "无分页查询",  notes = "无分页查询")
    public ResponseModel<List<WorkOrderPage>> wgpageList(
            @RequestBody WorkOrderPage  workOrder
    ) {

        //当前登录人所属场站
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());
        workOrder.setRegionCompanyId(userUnitInformationDto.getRegionalCompaniesSeq());
        workOrder.setAmosDealerId(userUnitInformationDto.getAmosDealerId());
        List<WorkOrderPage>  list=workOrderMapper.queryForwgpage(workOrder);
        return ResponseHelper.buildResponse(list);
    }


    //获取施工资料详情
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/getPowerStationConstructionData")
    @ApiOperation(httpMethod = "GET",value = "无分页查询",  notes = "无分页查询")
    public ResponseModel<Map<String,Object>> getPowerStationConstructionData(
            @RequestBody PowerStationConstructionData  powerStationConstructionData
    ) {
	    //查询施工信息
        LambdaQueryWrapper<PowerStationConstructionData> up=new LambdaQueryWrapper<>();
        up.eq(PowerStationConstructionData::getWorkOrderId,powerStationConstructionData.getWorkOrderId());
        up.eq(PowerStationConstructionData::getWorkOrderPowerStationId,powerStationConstructionData.getWorkOrderPowerStationId());
        PowerStationConstructionData da=  powerStationConstructionDataMapper.selectOne(up);
        Map<String,Object> map =new HashMap<>();
        map.put("powerStationConstructionData",da!=null?da:new PowerStationConstructionData());
        map.put("powerStationConstructionDatafj",da!=null?da:new PowerStationConstructionData());
        return ResponseHelper.buildResponse(map);
    }


    //施工信息添加

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/addOrUpdate")
    @ApiOperation(httpMethod = "GET",value = "无分页查询",  notes = "无分页查询")
    public ResponseModel<PowerStationConstructionData> addOrUpdate(
            @RequestBody PowerStationConstructionData  powerStationConstructionData
    ) {
        return ResponseHelper.buildResponse( workOrderServiceImpl.addOrUpdate(powerStationConstructionData));
    }



    /**
     * 勘察信息编辑
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "电站详情",   notes = "勘察信息编辑")
    @GetMapping(value = "/getsurveyQueryxq")
    public ResponseModel<SurveyInfoAllDto> getsurveyQueryxq(@RequestParam(value = "peasantHouseholdId" ) Long peasantHouseholdId,
                                                       @RequestParam(value = "workOrderId") Long workOrderId,
                                                       @RequestParam(value = "workOrderPowerStationId")Long workOrderPowerStationId) {

        SurveyInfoAllDto returnDto = workOrderServiceImpl.getsurveyQueryxq(peasantHouseholdId,workOrderId,workOrderPowerStationId);
        return ResponseHelper.buildResponse(returnDto);
    }




    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "完工登记详情",   notes = "完工登记详情")
    @GetMapping(value = "/getPowerStationEngineeringInfo")
    public ResponseModel<PowerStationEngineeringInfoAllDto> getPowerStationEngineeringInfo(@RequestParam(value = "workOrderPowerStationId")Long workOrderPowerStationId) {

        PowerStationEngineeringInfoAllDto returnDto = workOrderServiceImpl.getPowerStationEngineeringInfo(workOrderPowerStationId);
        return ResponseHelper.buildResponse(returnDto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "完工登记",   notes = "完工登记")
    @PostMapping (value = "/addPowerStationEngineeringInfo")
    public ResponseModel<PowerStationEngineeringInfoAllDto> addPowerStationEngineeringInfo(
            @RequestBody  PowerStationEngineeringInfoAllDto powerStationEngineeringInfoAllDto
    ) {

        workOrderServiceImpl.addPowerStationEngineeringInfo(powerStationEngineeringInfoAllDto);
        return ResponseHelper.buildResponse(powerStationEngineeringInfoAllDto);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "完工登记审核详情",   notes = "完工登记审核详情")
    @GetMapping(value = "/getConstructionRecords")
    public ResponseModel<PowerStationEngineeringInfoAllDto> getConstructionRecords(@RequestParam(value = "workOrderPowerStationId")Long workOrderPowerStationId) {

        PowerStationEngineeringInfoAllDto returnDto = workOrderServiceImpl.getConstructionRecords(workOrderPowerStationId,getUserInfo().getRealName());
        return ResponseHelper.buildResponse(returnDto);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "完工登记审核",   notes = "完工登记审核")
    @PostMapping(value = "/addConstructionRecords")
    public ResponseModel<ConstructionRecords> addConstructionRecords( @RequestBody  PowerStationEngineeringInfoAllDto constructionRecords) {
        ConstructionRecords da= constructionRecords.getConstructionRecords();
        da.setWorkOrderPowerStationId(constructionRecords.getWorkOrderPowerStationId());
        ConstructionRecords returnDto = workOrderServiceImpl.addConstructionRecords(da);
        return ResponseHelper.buildResponse(returnDto);
    }




}
