package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 字段提醒配置表
 *
 * @author system_generator
 * @date 2025-06-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_column_reminder_rule")
public class TzsJgColumnReminderRule extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 业务类型,如使用登记、安装告知
     */
    @TableField("biz_type")
    private String bizType;

    /**
     * 字段唯一标识
     */
    @TableField("column_key")
    private String columnKey;

    /**
     * 数据项名称
     */
    @TableField("column_label")
    private String columnLabel;

    /**
     * 数据项说明
     */
    @TableField("column_value")
    private String columnValue;

    /**
     * 0-新增；1-历史有证；2-历史无证
     */
    @TableField("reg_type")
    private String regType;

    /**
     * 设备种类编码，多个逗号分割
     */
    @TableField("equ_list")
    private String equList;

    /**
     * 未空代表公共，多个逗号分割
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 严重程度：1到n，数字越大，等级越高，自定义
     */
    @TableField("s_id")
    private Integer sId;

    /**
     * 是否车用气瓶
     */
    @TableField("whether_vehicle_cylinder")
    private String whetherVehicleCylinder;


    /**
     * 是否已经登记
     */
    @TableField("is_register")
    private Boolean isRegister;
}
