package com.yeejoin.amos.api.openapi.face.dto;

import com.yeejoin.amos.api.openapi.face.orm.entity.DesignInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MainParts;
import com.yeejoin.amos.api.openapi.face.orm.entity.MaintenanceInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.OtherInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.ProduceInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.ProtectionDevices;
import com.yeejoin.amos.api.openapi.face.orm.entity.RegistrationInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.SuperviseInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.UseInfo;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 监管设备信息
 * */
@Data
public class EquipmentInfoDto {

	/**
	 * 使用信息
	 */
	private UseInfo useInfo;

	/**
	 * 设计制造
	 */
	private DesignInfo designInfo;

	/**
	 * 制造信息
	 */
	private ProduceInfo factoryInfo;

	/**
	 * 监管信息
	 */
	private SuperviseInfo supervisionInfo;

	/**
	 * 注册登记
	 */
	private RegistrationInfo registerInfo;

	/**
	 * 维保备案
	 */
	private MaintenanceInfo maintenanceRecordInfo;
	/**
	 * 其他信息
	 */
	private OtherInfo otherInfo;

	/**
	 * 主要零部件
	 */
	private List<MainParts> mainParts;

	/**
	 * 保护装置
	 */
	private List<ProtectionDevices> protectionDevices;

	/**
	 * 设备参数信息
	 */
	private Map<String, Object> params;

	/**
	 * 操作类型 1 新增  0 修改
	 */
	private Integer saveStatus;

	/**
	 * 监管码
	 */
	private String supervisoryCode;

}
