package com.yeejoin.amos.boot.module.elevator.api.enums;

/**
 * 
 * <pre>
 * 电梯故障处置状态枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftServiceModelEnum.java, v 0.1 2021年9月29日 上午9:24:15 gwb Exp $
 */
public enum LiftAlarmDealStatusEnum{

	DISPOSAL_COMPLETED(0,"处置完成"),
	FAULT_OCCURRENCE(1,"故障发生"),
	GIVE_NOTICE(2,"发出通知"),
	DISPOSAL_RESPONSE(3,"处置响应"),
	DISPOSAL_SITE(4,"处置到场"),
	FALSE_ALARM(5,"误报");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftAlarmDealStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftAlarmDealStatusEnum getEnum(Integer code)
	{
		for (LiftAlarmDealStatusEnum liftAlarmDealStatusEnum : LiftAlarmDealStatusEnum.values())
		{
			if (liftAlarmDealStatusEnum.getCode().equals(code))
			{
				return liftAlarmDealStatusEnum;
			}
		}
		return null;
	}
}
