package com.yeejoin.amos.boot.module.jg.biz.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.FlowTaskVo;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class CmWorkflowServiceImpl implements ICmWorkflowService {

    /**
     * 通过
     */
    public static String PASS_OPERATE = "0";

    /**
     * 驳回
     */
    public static String REJECT_OPERATE = "1";



    @Override
    public List<ProcessTaskDTO> startBatch(ActWorkflowBatchDTO params) {
        List<ProcessTaskDTO> processTasks;
        try {
            log.info("开始请求工作流启动接口:/start/batch,请求参数：{}", JSONObject.toJSONString(params));
            processTasks = Workflow.taskV2Client.startForBatch(params).getResult();
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流批量启动失败", e);
            throw new RuntimeException("调用工作流批量启动失败");
        }
        return processTasks;
    }

    private String getErrorMessage(BaseException e){
        String devMessage = e.getDevMessage();
        if(devMessage.contains(";")){
            String tempMsg = devMessage.split(";")[0];
            if(tempMsg.contains(":")){
                devMessage =  tempMsg.split(":")[1];
            } else {
                devMessage = tempMsg;
            }
        }
        return devMessage;
    }

    @Override
    public ProcessTaskDTO completeOrReject(String taskId, TaskResultDTO data, String operate) {
        ProcessTaskDTO processTaskDTO;
        try {
            if(PASS_OPERATE.equals(operate)){
                // 通过操作
                log.info("开始请求工作流完成任务接口:/complete/standard/{taskId},请求参数：{},{}", taskId, JSONObject.toJSONString(data));
                processTaskDTO = Workflow.taskV2Client.completeByTaskFroStandard(taskId, data).getResult();
            } else if(REJECT_OPERATE.equals(operate)) {
                // 驳回操作
                log.info("开始请求工作流驳回任务接口:/reject/{taskId},请求参数：{},{}", taskId, JSONObject.toJSONString(data));
                processTaskDTO = Workflow.taskV2Client.reject(taskId, data).getResult();
            } else {
                // 执行普通节点（提交）
                log.info("开始请求工作流完成任务接口:/complete/standard/{taskId},请求参数：{},{}", taskId, JSONObject.toJSONString(data));
                processTaskDTO = Workflow.taskV2Client.completeByTaskFroStandard(taskId, data).getResult();
            }
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流完成任务接口失败", e);
            throw new RuntimeException("调用工作流完成任务接口失败");
        }
        return processTaskDTO;
    }

    @Override
    public ProcessTaskDTO rollBack(String processInstanceId) {
        log.info("开始请求工作流撤回接口:/rollBack/standard/{processInstanceId},请求参数：{}", processInstanceId);
        return FeignUtil.remoteCall(() -> Workflow.taskV2Client.rollBackTask(processInstanceId));
    }


    @Override
    public ProcessTaskDTO assign(FlowTaskVo taskVo) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        try {
            log.info("开始请求工作流转办任务接口:/assign/{taskVo},请求参数：{},{}", taskVo);
            processTaskDTO = Workflow.taskV2Client.assign(taskVo).getResult();
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流转办任务接口失败", e);
            throw new RuntimeException("调用工作流转办任务接口失败");
        }
        return processTaskDTO;
    }
}
