package com.yeejoin.amos.patrol.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 *  任务详情
 * 
 */
@Entity
@Table(name="p_task_detail")
@NamedQuery(name="TaskDetail.findAll", query="SELECT t FROM TaskDetail t")
public class TaskDetail extends BasicEntity{
	private static final long serialVersionUID = 1L;

	@Column(name="check_id")
	private int checkId; // 巡检记录ID

	@Column(name="item_id")
	private int itemId; // 检查项ID

	@Column(name="point_id")
	private int pointId; // 巡检点ID

	private String remark; // 说明

	@Column(name="route_id")
	private int routeId; // 巡检路线ID

	private int status;  // 任务项状态

	@Column(name="task_id")
	private long taskId; // 任务ID

	public TaskDetail() {
	}

	public int getCheckId() {
		return this.checkId;
	}

	public void setCheckId(int checkId) {
		this.checkId = checkId;
	}

	public int getItemId() {
		return this.itemId;
	}

	public void setItemId(int itemId) {
		this.itemId = itemId;
	}

	public int getPointId() {
		return this.pointId;
	}

	public void setPointId(int pointId) {
		this.pointId = pointId;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public int getRouteId() {
		return this.routeId;
	}

	public void setRouteId(int routeId) {
		this.routeId = routeId;
	}

	public int getStatus() {
		return this.status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public long getTaskId() {
		return this.taskId;
	}

	public void setTaskId(long taskId) {
		this.taskId = taskId;
	}

}