package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author tb
 * @date 2021-06-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_alert_form_value")
@ApiModel(value = "AlertFormValue对象", description = "AlertFormValue对象")
public class AlertFormValue extends BaseEntity {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "表单id")
    private Long alertFormId;

    @ApiModelProperty(value = "警情id")
    private Long alertCalledId;

    @ApiModelProperty(value = "警情类型")
    private String alertTypeCode;

    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    @ApiModelProperty(value = "英文名称")
    private String fieldCode;

    @ApiModelProperty(value = "字段值")
    private String fieldValue;

    @ApiModelProperty(value = "字段值字典code")
    private String fieldValueCode;

    @ApiModelProperty(value = "是否一行显示")
    private Boolean block;

    public AlertFormValue() {
        super();
    }

    public AlertFormValue(Long alertFormId, String fieldName, String fieldCode, boolean block) {
        this.alertFormId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.block = block;
    }

    public AlertFormValue(Long alertFormId, String fieldName, String fieldCode, boolean block, String alertTypeCode) {
        this.alertFormId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.block = block;
        this.alertTypeCode = alertTypeCode;
    }

    public AlertFormValue(Long alertFormId, String fieldName, String fieldCode, boolean block, String alertTypeCode,
                          String fieldValue, String fieldValueCode) {
        this.alertFormId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.block = block;
        this.alertTypeCode = alertTypeCode;
        this.fieldValue = fieldValue;
        this.fieldValueCode = fieldValueCode;
    }

    public AlertFormValue(Long alertFormId, String alertTypeCode, String fieldName, String fieldCode,
                          String fieldValue, String fieldValueCode, Boolean block) {
        this.alertFormId = alertFormId;
        this.alertTypeCode = alertTypeCode;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.fieldValue = fieldValue;
        this.fieldValueCode = fieldValueCode;
        this.block = block;
    }
}
