package com.yeejoin.amos.boot.module.tzs.api.enums;
/**
 * 
 * 派遣单枚举类
 * @author kongfm
 * @date 2021-08-04
 * ***/
public  enum DispatchPaperEnums {


	//完成状态 WCZT
	notFinish("notFinish","未完成"),
	hasFinished("hasFinished","已完成"),

	//处置环节 CZHJ

	receivedAlert("receivedAlert","已接警"),
	dispatched("dispatched",	"已派遣"),
	rescueArrived("rescueArrived",	"救援已到达"),
	repaireArrived("repaireArrived",	"维保已到达"),
	rescued("rescued",	"救援完成"),
	rescueBack("rescueBack",	"救援回访"),
	repaired("repaired",	"维修完成"),
	reportorBack("reportorBack",	"报修人已反馈"),
	disposed("disposed",	"维保已处置"),
	complainantBack("complainantBack",	"投诉人已回访"),


	// 警情类型 JJLX
	KRJY("KRJY","困人救援","250"),
	GZWX("GZWX",	"故障维修","251"),
	TSZX("TSZX",	"投诉咨询","252"),

	// 反馈方式 FKFS
	mainBack("mainBack","主动反馈"),
	phoneBack("phoneBack","电话回访"),

	// 维修结果 WXJG
	hasRepaired("hasRepaired","维修成功"),
	other("other","其他"),

	// 处置结果 CZJG
	hasDisposed("hasDisposed","已处置"),
	notDispose("notDispose","未处置"),

	// 反馈结果 FKJG
	satisfactory("satisfactory","满意"),
	unsatisfactory("unsatisfactory","不满意"),

	// 派遣单位 PQDW
	useUnit("useUnit","使用单位"),
	repairUnit("repairUnit","维保单位"),
	levelOneUnit("levelOneUnit","一级响应"),
	levelTwoUnit("levelTwoUnit","二级响应"),
	levelThreeUnit("levelThreeUnit","三级响应");





	private String code;
	private String value;
	private String dynamicCode;
	DispatchPaperEnums(String code, String value) {
		this.code=code;
		this.value=value;
	}
	DispatchPaperEnums(String code, String value, String dynamicCode) {
		this.code=code;
		this.value=value;
		this.dynamicCode = dynamicCode;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}

	public String getDynamicCode() {
		return dynamicCode;
	}

	public void setDynamicCode(String dynamicCode) {
		this.dynamicCode = dynamicCode;
	}

	public static DispatchPaperEnums getEnum(String code)
	{
		for (DispatchPaperEnums status : DispatchPaperEnums.values())
		{
			if (status.getCode().equals(code))
			{
				return status;
			}
		}
		return null;
	}

	
}
