package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.workflow.RemoteWorkFlowService;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import com.yeejoin.amos.boot.module.common.api.enums.FailureStatuEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureDetailsMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureAuditService;
import com.yeejoin.amos.boot.module.common.api.service.IFailureDetailsService;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-08-04
 */
@Service
public class FailureDetailsServiceImpl extends BaseService<FailureDetailsDto, FailureDetails, FailureDetailsMapper>
		implements IFailureDetailsService {

	@Autowired
	SourceFileServiceImpl sourceFileServiceImpl;

	@Autowired
	RemoteWorkFlowService remoteWorkFlowService;

	@Value("${failure.work.flow.processDefinitionKey}")
	private String processDefinitionKey;

	@Autowired
	IFailureAuditService failureAuditService;

	public static String EMERGENCY_COMMAND = "应急指挥科";

	private final Logger logger = LoggerFactory.getLogger(FailureDetailsServiceImpl.class);

	/**
	 * 分页查询
	 */
	public Page<FailureDetailsDto> queryForFailureDetailsPage(Page<FailureDetailsDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<FailureDetailsDto> queryForFailureDetailsList() {
		return this.queryForList("", false);
	}

	/**
	 * 根据状态查询
	 */
	public List<FailureDetails> queryForFailureDetailsList(Long currentStatus) {
		QueryWrapper<FailureDetails> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("current_status", currentStatus).orderByDesc("submission_time");
		return baseMapper.selectList(queryWrapper);

	}

	/**
	 * 发起故障保修单
	 */
	@Transactional
	public Object savemodel(FailureDetailsDto failureDetailsDto, ReginParams userInfo) {
		String businessKey = buildOrderNo();
		JSONObject jsonObject = remoteWorkFlowService.startNew(null, businessKey, processDefinitionKey);
		if (jsonObject == null) {
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			// return CommonResponseUtil.failure("启动流程失败");
		}
		JSONObject instance = jsonObject.getJSONObject("data");
		if (instance == null) {
			// return CommonResponseUtil.failure("无提交隐患权限");
		}
		failureDetailsDto.setCurrentStatus(FailureStatuEnum.WAITING_AUDIT.getCode());
		// 拿到流程processId
		failureDetailsDto.setProcessId(instance.getString("id"));
		FailureDetailsDto model = null;
		try {
			if (ObjectUtils.isNotEmpty(failureDetailsDto.getAttachment())) {
				sourceFileServiceImpl.saveSourceFile(failureDetailsDto.getSequenceNbr(),
						failureDetailsDto.getAttachment());
			}
			model = this.createWithModel(failureDetailsDto);
		} catch (Exception e) {
			logger.info("添加故障维修信息到数据库失败");
			return false;
			// return CommonResponseUtil.failure("添加失败");
		}
		if (ObjectUtils.isNotEmpty(model)) {
			excuteTask(false, model.getSequenceNbr(), instance.getString("id"), userInfo, null);
		}
		return true;
	}

	public boolean excuteTask(boolean falg, Long sequenceNbr, String procressId, ReginParams userInfo,
			String condition) {

		FailureDetailsDto failureDetailsDto = this.queryBySeq(sequenceNbr);
		// 获取送达部门的ID
		Integer failureEquipmentId = failureDetailsDto.getFailureEquipmentId();
		Long seq = userInfo.getDepartment().getSequenceNbr();
		Long auditDepartmentId = null;
		if (falg == true) {
			FailureAudit failureAudit = failureAuditService.findByFaultId(sequenceNbr);
			auditDepartmentId = failureAudit.getAuditDepartmentId();
		} else {
			auditDepartmentId = seq;
		}
		Map<String, Object> conditionMap = new HashMap<String, Object>();
		conditionMap.put("condition", condition);
		JSONObject teskObject = remoteWorkFlowService.getChildNodeDetail(procressId);
		try {
			if (ObjectUtils.isNotEmpty(teskObject)) {
				JSONArray taskDetailArray = teskObject.getJSONArray("data");
				for (Object obj : taskDetailArray) {
					JSONObject detail = JSONObject.parseObject(JSONObject.toJSONString(obj));
					String name = detail.getString("name");
					if (name.contains(EMERGENCY_COMMAND) && auditDepartmentId.intValue() == seq.intValue()) {
						String taskId = detail.getString("id");
						remoteWorkFlowService.excute(taskId, conditionMap.toString());
						break;
					} else {
						if (failureEquipmentId.intValue() == seq.intValue()) {
							String taskId = detail.getString("id");
							remoteWorkFlowService.excute(taskId, conditionMap.toString());
							break;
						}
					}
				}
			}
		} catch (Exception e) {
			return false;
		}
		return true;
	}
	public boolean checkExcuteTaskAuth(boolean falg,Long sequenceNbr, ReginParams userInfo) {
		Long seq = userInfo.getDepartment().getSequenceNbr();
		Long auditDepartmentId = null;
		if (falg == true) {
			FailureAudit failureAudit = failureAuditService.findByFaultId(sequenceNbr);
			auditDepartmentId = failureAudit.getAuditDepartmentId();
		} else {
			auditDepartmentId = seq;
		}
		return	checkExcuteTaskAuth(auditDepartmentId,sequenceNbr,userInfo);
	}
	public boolean checkExcuteTaskAuth(Long auditDepartmentId,Long sequenceNbr, ReginParams userInfo) {
		FailureDetailsDto failureDetailsDto = this.queryBySeq(sequenceNbr);
		// 获取送达部门的ID
		Integer failureEquipmentId = failureDetailsDto.getFailureEquipmentId();
		FailureAudit failureAudit = failureAuditService.findByFaultId(sequenceNbr);
		//获取上一级操作部门的Id
		FailureDetails details = this.baseMapper.selectById(sequenceNbr);
		String procressId = details.getProcessId();
		Long seq = userInfo.getDepartment().getSequenceNbr();
		JSONObject teskObject = remoteWorkFlowService.getChildNodeDetail(procressId);
		if (ObjectUtils.isNotEmpty(teskObject)) {
			JSONArray taskDetailArray = teskObject.getJSONArray("data");
			for (Object obj : taskDetailArray) {
				JSONObject detail = JSONObject.parseObject(JSONObject.toJSONString(obj));
				String name = detail.getString("name");
				if (name.contains(EMERGENCY_COMMAND) && auditDepartmentId.intValue() == seq.intValue()) {
					return true;
				} else {
					if (failureEquipmentId.intValue() == seq.intValue()) {
						return true;
					}
				}
			}
		}
		return false;
	}

	public Object getCurrentProcessHistoryTask(Long id) {
		FailureDetailsDto failureDetailsDto = this.queryBySeq(id);
		String processId = failureDetailsDto.getProcessId();
		JSONObject historyObject = remoteWorkFlowService.queryFinishTaskDetailByInstanceId(processId);
		return logger;

	}

	public static String buildOrderNo() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String newDate = sdf.format(new Date());
		String result = "";
		Random random = new Random();
		for (int i = 0; i < 3; i++) {
			result += random.nextInt(10);
		}
		return newDate + result;
	}
}