package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureMaintainDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureMaintain;
import com.yeejoin.amos.boot.module.common.api.enums.AuditResultEnum;
import com.yeejoin.amos.boot.module.common.api.enums.FailureStatuEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureMaintainMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureMaintainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-08-04
 */
@Service
public class FailureMaintainServiceImpl extends BaseService<FailureMaintainDto,FailureMaintain,FailureMaintainMapper> implements IFailureMaintainService {
    @Autowired
    SourceFileServiceImpl sourceFileServiceImpl;
    @Autowired
    FailureDetailsServiceImpl failureDetailsService;

    /**
     * 分页查询
     */
    public Page<FailureMaintainDto> queryForFailureMaintainPage(Page<FailureMaintainDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FailureMaintainDto> queryForFailureMaintainList()   {
        return this.queryForList("" , false);
    }

    /**
     * 添加维修记录
     */
    public FailureMaintainDto savemodel(FailureMaintainDto failureMaintainDto)   {
        this.createWithModel(failureMaintainDto);

        //添加完成后修改保修单状态为待验收
        FailureDetailsDto failureDetailsDto = failureDetailsService.queryBySeq(failureMaintainDto.getFaultId());
        failureDetailsDto.setCurrentStatus(FailureStatuEnum.WAITING_ACCEPTANCE.getCode());
        failureDetailsService.updateWithModel(failureDetailsDto);

        sourceFileServiceImpl.saveSourceFile(failureMaintainDto.getSequenceNbr(),failureMaintainDto.getAttachment());
        return failureMaintainDto;
    }

    /**
     *根据审核结果更新维修表
     */
    public FailureMaintainDto updateModel(FailureMaintainDto failureMaintainDto,Integer status)   {

        this.updateWithModel(failureMaintainDto);
        //根据status修改状态
        FailureDetailsDto failureDetailsDto = failureDetailsService.queryBySeq(failureMaintainDto.getFaultId());
        if (status == AuditResultEnum.AGREE.getCode()) {//同意状态为已完结
            failureDetailsDto.setCurrentStatus(FailureStatuEnum.FINISH.getCode());
            failureDetailsService.updateWithModel(failureDetailsDto);
        }else {//不同意状态为已拒绝
            failureDetailsDto.setCurrentStatus(FailureStatuEnum.REFUSE.getCode());
            failureDetailsService.updateWithModel(failureDetailsDto);
        }
        return failureMaintainDto;
    }
   /**
    * 查询当前故障报修单的流程的审批历史节点
    * @param sequenceNbr
    * @return
    */
	public List<Object> getProcessHistoryList(Long sequenceNbr) {
		// TODO Auto-generated method stub
		return null;
	}
}